<?php
$lang = new stdclass();

$lang->grid  = 'Grid line';
$lang->xLine = 'X axis';
$lang->yLine = 'Y axis';
$lang->column    = 'Column';
$lang->xAxisName = 'X axis title';
$lang->yAxisName = 'Y axis title';
$lang->highlight = 'Highlight';

$lang->config = new stdclass();

$lang->config->grid              = 'Grid line';
$lang->config->gridEnum          = array();
$lang->config->gridEnum['xaxis'] = 'X axis';
$lang->config->gridEnum['yaxis'] = 'Y axis';
$lang->config->gridConfig        = array('name' => 'grid', 'label' => $lang->config->grid, 'type' => 'checkbox', 'enumOptions' => $lang->config->gridEnum, 'defaultValue' => array());

$lang->config->label              = 'Data display';
$lang->config->labelEnum          = array();
$lang->config->labelEnum['xaxis'] = 'X axis';
$lang->config->labelEnum['yaxis'] = 'Y axis';
$lang->config->labelConfig        = array('name' => 'label', 'label' => $lang->config->label, 'type' => 'checkbox', 'enumOptions' => $lang->config->labelEnum, 'defaultValue' => '');

$lang->config->legend              = 'Legend';
$lang->config->legendEnum          = array();
$lang->config->legendEnum['true']  = 'Show';
$lang->config->legendEnum['false'] = 'Hide';
$lang->config->legendConfig        = array('name' => 'legend', 'label' => $lang->config->legend, 'type' => 'radio', 'enumOptions' => $lang->config->legendEnum, 'defaultValue' => 'true');

$lang->config->title              = 'Axis title';
$lang->config->titleEnum          = array();
$lang->config->titleEnum['xaxis'] = 'X axis';
$lang->config->titleEnum['yaxis'] = 'Y axis';
$lang->config->titleConfig        = array('name' => 'title', 'label' => $lang->config->title, 'type' => 'checkbox', 'enumOptions' => $lang->config->titleEnum, 'defaultValue' => array('xaxis', 'yaxis'));

$lang->config->orientation          = 'Orientation';
$lang->config->orientationEnum      = array();
$lang->config->orientationEnum['v'] = 'Vertical';
$lang->config->orientationEnum['h'] = 'Horizontal';

$lang->common = new stdclass();
$lang->common->columnNotAllNumber = 'Selected column "%s" include non-numberic value';
$lang->common->columnNoNumber     = 'Selected column "%s" not include any numberic value';
$lang->common->errorColEqual      = 'Select a valid column with the same number of rows as the variable column and ≥2 rows.';
$lang->common->errorRowEqual      = 'Select a valid column. At least two rows in the column must have the same data.';
$lang->common->errorLine          = 'Can not select empty column:%s';
$lang->common->allSame            = 'All values in the group are the same';
$lang->common->notSameLine        = 'The input column lengths are not same';
$lang->common->haveEmptyLine      = 'The input column has a null value:%s';
$lang->common->haveStringLine     = 'The input column has a non-numeric value (string):%s';
$lang->common->continuousError    = 'Column data cannot contain null values';
$lang->common->notNumberError     = 'Column data must be numerical values';
$lang->common->notPositiveError   = 'All data in the column must be positive';
$lang->common->notIntegerError    = 'All data in the column must be integers';
$lang->common->notCommonError     = 'Column data cannot be constant columns';
$lang->common->rowNotEqualError   = 'Column data Column lengths must be equal';
$lang->common->rowLengthError     = 'Column data column lengths must be >= %s';
$lang->common->groupLengthError   = 'The number of items in each category group after column data classification must be >= %s';
$lang->common->group2Error        = 'The number of category groups after column data is classified must be 2.';

$lang->common->notEmptyError     = '[%s] columns cannot be empty.';
$lang->common->continuousError   = '[%s] columns cannot contain null values, invalid value row is %s.';
$lang->common->numberError       = '[%s] columns must all be numeric values, invalid value row is %s.';
$lang->common->notCommonError    = '[%s] columns cannot be constant columns.';
$lang->common->uniqueError       = '[%s] columns cannot contain duplicate values.';
$lang->common->intError          = '[%s] columns must all be integers, invalid value row is %s.';
$lang->common->positiveError     = '[%s] all columns need to be greater than 0, invalid value row is %s.';
$lang->common->nonnegativeError  = '[%s] columns need to be nonnegative, invalid value row is %s.';
$lang->common->rowEqualError     = '[%s] columns need to be identical.';
$lang->common->columnUniqueError = '[%s] column requires the number of categories %s.';
$lang->common->unionUniqueError  = '[%s] union column requires the number of categories %s。';
$lang->common->numberCountError  = '[%s] column requires count %s。';
$lang->common->invertibleError   = 'Data errors form an irreversible matrix.';

$lang->fourInOne = new stdclass();

$lang->fourInOne->data         = "Data";
$lang->fourInOne->residual     = "Residual";
$lang->fourInOne->frequency    = "Frequency";
$lang->fourInOne->fit          = "Fit";
$lang->fourInOne->fitValue     = "Fitted value";
$lang->fourInOne->response     = "Response %s";
$lang->fourInOne->withFit      = "Plot of residual and fitted values";
$lang->fourInOne->histogram    = "Histogram of residual frequency";
$lang->fourInOne->percent      = "Percent";
$lang->fourInOne->withOrder    = "Sequence diagram of residuals and observations";
$lang->fourInOne->normal       = "Normal probability plot of the residuals";
$lang->fourInOne->observeOrder = "Observation order";

$lang->fourInOne->errorSD = "A graph of the specified residual type cannot be drawn because the mean square error = 0 or the degree of freedom of error = 0";

$lang->simulate = new stdclass();
$lang->simulate->cols = array_fill(1, 20, 'C');

$lang->simulate->standardDeviation = 'Standard deviation';
$lang->simulate->mean              = 'Mean value';
$lang->simulate->count             = 'Rows';
$lang->simulate->col               = 'Add to column';

$lang->simulate->errorSD    = 'The standard deviation can only be entered as a positive number.';
$lang->simulate->errorMean  = 'Only numbers are allowed for the mean.';
$lang->simulate->errorCount = 'Only 1 to 1000 rows of data can be generated.';

$methods = array('analysis', 'control', 'graphic', 'hypothesis', 'statistic');

foreach($methods as $method)
{
    $methodDir = LIB_ROOT . "/das/lang/methods/$method/en";
    $files = glob($methodDir . '/*.php');
    foreach ($files as $file) include $file;
}

$simulateDir = LIB_ROOT . "/das/lang/simulate/en";
$files = glob($simulateDir . '/*.php');
foreach ($files as $file) include $file;
