<?php
/**
 * 创建所有的内置分析项目。
 * Create all initial perfprojects.
 *
 * @param  string|null $version
 * @access public
 * @return void
 */
public function initPerfprojects($version = null)
{
    $this->app->setVision();
    $this->app->loadLang('perfproject');
    $this->app->loadConfig('perfproject');
    if(!empty($version))
    {
        $initPerfprojects = array_filter($this->config->perfproject->projects, function($item) use ($version) {return $item['version'] == $version;});
        foreach($initPerfprojects as $project) $this->initPerfproject($project, $version);
    }
    else
    {
        foreach($this->config->perfproject->projects as $project)
        {
            $this->initPerfproject($project);
        }
    }
}

public function initPerfproject(&$project, $version = null)
{
    $demoProjectID = $project['id'];
    unset($project['id']);
    unset($project['version']);
    $project['createdBy']   = $this->app->user->account;
    $project['createdDate'] = helper::now();
    $this->dao->insert("`perf_project`")->data((object)$project, 'id')->exec();

    $projectID = $this->dao->lastInsertID();
    if($projectID) $this->initPerfanalysises($projectID, $demoProjectID);
}

public function initPerfanalysises($projectID, $demoProjectID)
{
    $perfanalysises = array_filter($this->config->perfproject->analysises, function($item) use ($demoProjectID)
    {
        return $item['project'] == $demoProjectID;
    });
    foreach($perfanalysises as $analysis)
    {
        $analysis['project'] = $projectID;
        $this->initPerfanalysis($analysis);
    }
}

public function initPerfanalysis(&$analysis)
{
    $demoAnalysisID = $analysis['id'];
    unset($analysis['version']);
    unset($analysis['id']);

    $analysis['createdBy']   = $this->app->user->account;
    $analysis['createdDate'] = helper::now();

    $this->dao->insert("`perf_analysis`")->data((object)$analysis, 'id')->exec();
    $analysisID = $this->dao->lastInsertID();
    if($analysisID)
    {
        $tableName = 'perf_analysis' . $analysisID;
        $schema    = json_decode($analysis['schema'], true);
        $schema['table'] = $tableName;
        $this->dao->update("`perf_analysis`")->set('schema')->eq(json_encode($schema))->where('id')->eq($analysisID)->exec();

        $demoTableName = 'perf_analysis' . $demoAnalysisID;
        $tableData     = $this->config->perfproject->$demoTableName;
        $keys          = array_keys($tableData[0]);
        $tableHeader   = array_values(array_diff($keys, array('id', 'version')));
        $this->initSchema($tableName, $tableHeader);
        foreach($tableData as $data) $this->dao->insert("`$tableName`")->data((object)$data, 'id')->exec();

        $this->initPerfmethods($analysisID, $demoAnalysisID);
    }
}

public function initPerfmethods($analysisID, $demoAnalysisID)
{
    if(!empty($version))
    {
        $perfmethods = array_filter($this->config->perfproject->methods, function($item) use ($demoAnalysisID)
        {
            return $item['analysis'] == $demoAnalysisID;
        });
        foreach($perfmethods as $method)
        {
            $method['analysis'] = $analysisID;
            $this->initPerfmethod($method);
        }
    }
    else
    {
        foreach($this->config->perfproject->methods as $method)
        {
            if($method['analysis'] == $demoAnalysisID)
            {
                $method['analysis'] = $analysisID;
                $this->initPerfmethod($method);
            }
        }
    }
}

public function initPerfmethod(&$method)
{
    unset($method['id']);
    $this->dao->insert("`perf_method`")->data((object)$method, 'id')->exec();
}

public function initSchema($tableName, $tableHeader)
{
    $sql  = "DROP TABLE IF EXISTS `$tableName`;\n";
    $sql .= "CREATE TABLE IF NOT EXISTS `$tableName` ( ";
    if($this->config->db->driver == "sqlite")
    {
        $sql.= "`id` INTEGER PRIMARY KEY AUTOINCREMENT, ";
    }
    else
    {
        $sql .= "`id` mediumint unsigned NOT NULL AUTO_INCREMENT, ";
    }
    foreach($tableHeader as $header)
    {
        $sql .= "`{$header}` text, ";
    }

    if($this->config->db->driver == "sqlite")
    {
        $sql = rtrim($sql, ', ') . ");";
    }
    else
    {
        $sql .= "PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8;";
    }

    try
    {
        if($this->config->db->driver == "sqlite")
        {
            $sqls = $this->sqlToArr($sql);
            foreach($sqls as $sql) $this->app->dbh->query($sql);
        }
        else
        {
            $this->app->dbh->setAttribute(PDO::ATTR_EMULATE_PREPARES, 1);
            $this->app->dbh->query($sql);
        }
    }
    catch(PDOException $exception)
    {
        a($exception);
        a($sql);
        return false;
    }

    return true;
}
