<?php
/**
 * The execution view file of execution module of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Sun Guangming<sunguangming@easycorp.ltd>
 * @package     execution
 * @link        https://www.zentao.net
 */

namespace zin;

jsVar('status',    $status);
jsVar('projectID', $projectID);
jsVar('orderBy',   $orderBy);
jsVar('productID', $productID);
jsVar('typeList', $lang->execution->typeList);
jsVar('delayed', $lang->execution->delayed);
jsVar('delayWarning', $lang->task->delayWarning);
jsVar('pageExecSummary', $lang->execution->pageExecSummary);
jsVar('checkedExecSummary', $lang->execution->checkedExecSummary);
jsVar('confirmCreateStage', $lang->project->confirmCreateStage);

$searchTask = strtolower($status) == 'bysearch';
$isFromPerf = $from == 'perf';

if($isFromPerf)
{
    $projectChangeLink = createLink('project', 'execution', "status=$status&projectID={projectID}&orderBy=$orderBy&productID=$productID&recTotal={$pager->recTotal}&recPerPage={$pager->recPerPage}&pageID={$pager->pageID}&queryID=$queryID&from=perf&blockID=$blockID");
    $perfprojectLink   = createLink('perfproject', 'create', "analysisID=$blockID&type={type}");
    $tableList         = $this->loadModel('perfproject')->getTableListMenu();
    $this->app->loadLang('perfanalysis');
    jsVar('perfTableList', $lang->perfproject->tableList);
    jsVar('tableName', $config->db->prefix . 'project');
    jsVar('dataAnalysisLang', $lang->perfproject->list . $lang->perfproject->dataAnalysis);
    jsVar('analysisID', $blockID);
    jsVar('tableList', $tableList);
    if(!empty($blockID)) unset($lang->perfproject->dataTypeList['empty']);

    formPanel
    (
        setID('zentaolist'),
        setStyle(array('margin-bottom' => '16px !important')),
        set::actions(array()),
        set::showExtra(false),
        set::title(!empty($blockID) ? $lang->perfanalysis->addData : $this->lang->perfproject->createTitle),
        formGroup
        (
            set::label($lang->perfproject->selectData),
            set::required(true),
            radioList
            (
                set::inline(true),
                set::name('sourcetype'),
                set::items($lang->perfproject->dataTypeList),
                set::value('select'),
                on::change('[name="sourcetype"]')->do("if($(this).val() != 'select') loadModal('$perfprojectLink'.replace('{type}', $(this).val()))")
            )
        ),
        formGroup
        (
            set::label($lang->perfproject->selectTable),
            set::required(true),
            set::width('1/2'),
            setClass('relative'),
            picker
            (
                set::name('listType'),
                set::value('execution'),
                set::items($tableList),
                set::required(true),
                on::change('[name="listType"]')->call("changeListType", jsRaw('this'))
            ),
            btn(setClass('ghost form-label-hint text-gray cursor-pointer absolute top-1'), setStyle(array('right' => '-26px')), set::size('sm'), set::icon('help'), setClass(''), toggle::tooltip(array('title' => $lang->perfproject->tips->selectTable, 'className' => 'text-gray border border-gray-300', 'type' => 'white', 'placement' => 'right')))
        ),
        formRow
        (
            formGroup
            (
                set::width('1/2'),
                set::name('project'),
                set::label($lang->execution->project),
                set::control(array('required' => $isFromPerf)),
                set::items($projects),
                set::value($projectID),
                set::required(),
                span
                (
                    setClass('error-tip text-danger hidden'),
                    $lang->perfproject->emptyError
                ),
                on::change('[name="project"]')->do("loadModal('$projectChangeLink'.replace('{projectID}', $(this).val()));")
            )
        )
    );
}

$footToolbar = array();
$canModify            = common::canModify('project', $project);
$canBatchEdit         = hasPriv('execution', 'batchEdit');
$canBatchChangeStatus = hasPriv('execution', 'batchChangeStatus');
$canBatchAction       = $canModify && ($canBatchEdit || $canBatchChangeStatus);
if($canBatchAction)
{
    if($canBatchEdit)
    {
        $footToolbar['items'][] = array
        (
            'type'  => 'btn-group',
            'items' => array
            (
                array('text' => $lang->edit, 'className' => "secondary size-sm batch-btn", 'btnType' => 'primary', 'data-url' => createLink('execution', 'batchEdit')),
            )
        );
    }

    if($canBatchChangeStatus)
    {
        $statusItems = array();
        foreach($lang->execution->statusList as $key => $value)
        {
            $statusItems[] = array('text' => $value, 'innerClass' => 'batch-btn ajax-btn', 'data-url' => createLink('execution', 'batchChangeStatus', "status=$key"));
        }

        $footToolbar['items'][] = array('caret' => 'up', 'text' => $lang->statusAB,   'className' => 'btn btn-caret size-sm secondary', 'items' => $statusItems, 'type' => 'dropdown', 'data-placement' => 'top-start');
    }
}
if($isFromPerf) $footToolbar = array(array('text' => !empty($blockID) ? $lang->save : $lang->perfproject->create, 'data-on' => 'click', 'data-call' => "insertListToPerf"));

/* Generate data table fields. */
$fieldList = $config->project->execution->dtable->fieldList;
$fieldList['status']['statusMap']['changed'] = $lang->task->storyChange;

/* waterfall & waterfallplus model with different edit link. */
if(in_array($project->model, array('waterfall', 'waterfallplus')))
{
    $fieldList['actions']['actionsMap']['edit']['data-size'] = 'md';
    $fieldList['actions']['actionsMap']['edit']['url'] = createLink('programplan', 'edit', "stageID={rawID}&projectID={projectID}");

    $fieldList['actions']['actionsMap']['createChildStage']['url'] = 'javascript:confirmCreateStage({projectID}, {productID}, {rawID}, {hasChild});';
}
if(!$this->cookie->showStage && !$this->cookie->showTask)
{
    $fieldList['name']['type'] = 'title';
    if(!in_array($project->model, array('waterfall', 'waterfallplus', 'ipd'))) unset($fieldList['name']['nestedToggle']);
}
if(!$project->hasProduct) unset($fieldList['productName']);

$config->project->execution->dtable->fieldList = $fieldList;
$fieldList = $this->loadModel('datatable')->getSetting('project', 'execution');
$fieldList['name']['name'] = 'nameCol';
$fieldList['actions']['width'] = '160';

foreach(array_keys($fieldList['actions']['actionsMap']) as $actionKey) unset($fieldList['actions']['actionsMap'][$actionKey]['text']);
$fieldList['status']['statusMap']['changed'] = $lang->task->storyChange;
if($isFromPerf) $fieldList['status']['statusMap']['start'] = $lang->execution->statusList['doing'];

$executions = $this->execution->generateRow($executionStats, $users, $avatarList);
foreach($executions as $execution) $execution->nameCol = $execution->name;

/* zin: Define the feature bar on main menu. */
$productItems = array();
foreach($productList as $key => $value) $productItems[] = array('text' => $value, 'active' => $key == $productID, 'url' => createLink('project', 'execution', "status={$status}&projectID={$projectID}&orderBy={$orderBy}&productID={$key}"));

$productName   = !empty($product) ? $product->name : '';
$queryMenuLink = createLink('project', 'execution', "status={key}&projectID={$projectID}&orderBy={$orderBy}&productID={$productID}&recTotal={$pager->recTotal}&recPerPage={$pager->recPerPage}&pageID={$pager->pageID}&queryID=$queryID&from=$from&blockID=$blockID");
featureBar
(
    (!$isFromPerf && $project->stageBy == 'product' && $project->hasProduct) ? to::leading
    (
        dropdown
        (
            to('trigger', btn($productName ? $productName : $lang->product->all, setClass('ghost'))),
            set::items($productItems)
        )
    ) : null,
    set::module('project'),
    set::method('execution'),
    set::current($status),
    set::linkParams("status={key}&projectID={$projectID}&orderBy={$orderBy}&productID={$productID}&recTotal={$pager->recTotal}&recPerPage={$pager->recPerPage}&pageID={$pager->pageID}&queryID=$queryID&from=$from&blockID=$blockID"),
    set::isModal($isFromPerf),
    set::queryMenuLinkCallback(array(function ($key) use ($queryMenuLink) {
        return str_replace('{queryID}', (string)$key, $queryMenuLink);
    })),
    $isFromPerf ? null : array(
        li
        (
            checkbox
            (
                set::id('showTask'),
                set::name('showTask'),
                set::checked($this->cookie->showTask ? 'checked' : ''),
                set::text($lang->programplan->stageCustom['task']),
                set::rootClass('ml-4')
            )
        ),
        $project->model == 'ipd' ? li
        (
            checkbox
            (
                set::id('showStage'),
                set::name('showStage'),
                set::checked($this->cookie->showStage ? 'checked' : ''),
                set::text($lang->programplan->stageCustom['point']),
                set::rootClass('ml-4')
            )
        ) : null,
        $this->cookie->showTask ? li(setClass('ml-2'), searchToggle(set::module('projectTask'), set::open($searchTask))) : null
    )
);

/* zin: Define the toolbar on main menu. */
$createLink       = $isStage ? createLink('programplan', 'create', "projectID={$projectID}&productID={$productID}") : createLink('execution', 'create', "projectID={$projectID}");
$canModifyProject = common::canModify('project', $project);
if(!$canModifyProject) $fieldList['actions']['actionsMap'] = array();

if($isFromPerf)
{
    if(isset($fieldList['actions'])) unset($fieldList['actions']);
    foreach($fieldList as $key => $col)
    {
        $fieldList[$key]['sortType'] = false;
        if(isset($col['link'])) unset($fieldList[$key]['link']);
        if($key == 'PM') $fieldList[$key]['type'] = 'user';
    }
    $fieldList = array_values($fieldList);
}

$isFromPerf ? null : toolbar
(
    in_array($project->model, array('waterfall', 'waterfallplus', 'ipd')) && in_array($this->config->edition, array('max', 'ipd')) ? btnGroup
    (
        a(setClass('btn square'), icon('gantt-alt'), set::title($lang->programplan->gantt), set::href(createLink('programplan', 'browse', "projectID=$projectID&productID=$productID&type=gantt"))),
        a(setClass('btn square text-primary'), icon('list'), set::title($lang->project->bylist))
    ) : null,
    hasPriv('execution', 'export') ? item(set(array
    (
        'icon'        => 'export',
        'text'        => $lang->programplan->exporting,
        'class'       => "ghost export",
        'data-toggle' => "modal",
        'url'         => createLink('execution', 'export', "status={$status}&productID={$productID}&orderBy={$orderBy}&from=project")
    ))) : null,
    $canModifyProject && common::hasPriv('programplan', 'create') && $isStage && empty($product->deleted) ? item(set(array
    (
        'icon'  => 'plus',
        'text'  => $lang->programplan->create,
        'class' => "primary create-execution-btn",
        'url'   => $createLink
    ))) : null,
    $canModifyProject && hasPriv('execution', 'create') && !$isStage && $project->model != 'agileplus' ? item(set(array
    (
        'icon'  => 'plus',
        'text'  => $isStage ? $lang->programplan->create : $lang->execution->create,
        'class' => "primary create-execution-btn",
        'url'   => $createLink
    ))) : null,
    $canModifyProject && hasPriv('execution', 'create') && !$isStage && $project->model == 'agileplus' ?  btngroup(
        setClass('create-execution-btn'),
        btn(setClass('btn primary'), set::icon('plus'), set::url($createLink), $lang->execution->create),
        dropdown
        (
            btn(setClass('btn primary dropdown-toggle'),
            setStyle(array('padding' => '6px', 'border-radius' => '0 2px 2px 0'))),
            set::items
            (
                array('text' => $lang->execution->create, 'url' => $createLink),
                array('text' => $lang->project->createKanban, 'url' => createLink('execution', 'create', "projectID={$projectID}&executionID=0&copyExecutionID=&planID=0&confirm=no&productID=0&extra=type=kanban"))
            ),
            set::placement('bottom-end')
        )
    ) : null
);

$canCreateExecution = $canModifyProject &&  $isStage ? common::hasPriv('programplan', 'create') : common::hasPriv('execution', 'create');
dtable
(
    set::userMap($users),
    set::cols($fieldList),
    set::data($executions),
    set::checkable($canBatchAction || $isFromPerf),
    $isFromPerf ? null : set::onRenderCell(jsRaw('window.onRenderCell')),
    set::isFromDoc($isFromPerf),
    set::canRowCheckable(jsRaw("function(rowID){return this.getRowInfo(rowID).data.id.indexOf('pid') > -1;}")),
    set::footToolbar($footToolbar),
    set::orderBy($orderBy),
    set::footPager(usePager(array('linkCreator' => createLink('project', 'execution', "status={$status}&projectID=$projectID&orderBy={$orderBy}&productID={$productID}&recTotal={recTotal}&recPerPage={recPerPage}&page={page}&queryID=$queryID&from=$from&blockID=$blockID")))),
    set::emptyTip(!$searchTask ? $lang->execution->noExecution : $lang->task->noTask),
    !$isFromPerf ? null : set::afterRender(jsCallback()->call('toggleCheckRows', $idList)),
    !$isFromPerf ? null : set::onCheckChange(jsRaw('window.checkedChange')),
    !$isFromPerf ? null : set::height(400),
    $isFromPerf ? null : set::customCols(true),
    $isFromPerf ? null : set::checkInfo(jsRaw("function(checkedIDList){ return window.footerSummary(this, checkedIDList);}")),
    $isFromPerf ? null : set::sortLink(createLink('project', 'execution', "status={$status}&projectID=$projectID&orderBy={name}_{sortType}&productID={$productID}&recTotal={$pager->recTotal}&recPerPage={$pager->recPerPage}&pageID={$pager->pageID}")),
    $isFromPerf ? null : set::createTip($isStage ? $lang->programplan->create : $lang->execution->create),
    $isFromPerf ? null : set::createLink($canCreateExecution && !$searchTask ? $createLink : ''),
    $isFromPerf ? null : set::createAttr($isStage ? 'data-app="project"' : 'data-app="execution"')
);

render();
