SET NAMES utf8mb4;

-- DROP TABLE IF EXISTS `perf_datasource`;
CREATE TABLE `perf_datasource` (
  `id` mediumint NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `type` varchar(100) NOT NULL,
  `name` varchar(100) COLLATE 'utf8mb4_bin' NOT NULL,
  `acl` enum('open','private') NOT NULL default 'open',
  `whitelist` text NOT NULL,
  `desc` mediumtext NOT NULL,
  `extension` char(30) NOT NULL default 'xlsx',
  `size` int(10) unsigned NOT NULL default '0',
  `connection` mediumtext NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `deleted` tinyint NOT NULL
);

-- DROP TABLE IF EXISTS `perf_project`;
CREATE TABLE `perf_project` (
  `id` int NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `name` varchar(100) COLLATE utf8mb4_bin NOT NULL,
  `acl` enum('open','private') NOT NULL default 'open',
  `whitelist` text NOT NULL,
  `source` mediumint NOT NULL,
  `table` varchar(100) NOT NULL,
  `schema` mediumtext COLLATE 'utf8mb4_bin' NOT NULL,
  `desc` mediumtext COLLATE 'utf8mb4_bin' NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `deleted` tinyint NOT NULL DEFAULT '0'
) ENGINE=MyISAM COLLATE 'utf8mb4_bin';

-- DROP TABLE IF EXISTS `perf_analysis`;
CREATE TABLE `perf_analysis` (
  `id` mediumint NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `name` varchar(255) NOT NULL,
  `project` mediumint NOT NULL,
  `schema` mediumtext COLLATE 'utf8mb4_bin' NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `deleted` tinyint NOT NULL DEFAULT '0'
) ENGINE=MyISAM COLLATE 'utf8mb4_bin';

-- DROP TABLE IF EXISTS `perf_method`;
CREATE TABLE `perf_method` (
  `id` mediumint NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `title` varchar(255) NOT NULL,
  `analysis` mediumint NOT NULL,
  `name` varchar(100) NOT NULL,
  `config` mediumtext COLLATE 'utf8mb4_bin' DEFAULT NULL,
  `settings` mediumtext COLLATE 'utf8mb4_bin' NOT NULL,
  `results` mediumtext NOT NULL,
  `resultIDList` text NOT NULL,
  `draft` enum('0', '1') DEFAULT '0',
  `deleted` tinyint NOT NULL DEFAULT '0'
) COLLATE 'utf8mb4_bin';
