<?php
/**
 * The browse view file of risk module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yuting Wang <wangyuting@easycorp.ltd>
 * @package     risk
 * @link        https://www.zentao.net
 */
namespace zin;

jsVar('pageSummary', $lang->risk->pageSummary);
jsVar('checkedSummary', $lang->risk->checkedSummary);
jsVar('browseType', $browseType);

if($app->tab == 'safe')
{
    dropmenu(set::tab('pi'), set::objectID($projectID));
}
else if($app->tab == 'execution')
{
    dropmenu(set::tab('execution'), set::objectID($projectID), set::url(createLink('execution', 'ajaxGetDropMenu', "projectID=$projectID&module=risk&method=browse")));
}
else if($app->tab == 'project')
{
    dropmenu(set::tab('project'), set::objectID($projectID), set::url(createLink('project', 'ajaxGetDropMenu', "projectID=$projectID&module=risk&method=browse")));
}

featureBar
(
    set::linkParams("projectID=$projectID&from=$from&browseType={key}"),
    li(searchToggle(set::module('risk'), set::open($browseType == 'bysearch')))
);

$hasRisklib     = helper::hasFeature('risklib');
$canCreate      = hasPriv('risk', 'create');
$canBatchCreate = hasPriv('risk', 'batchCreate');
$canBatchACtion = $app->tab != 'safe' && hasPriv('risk', 'batchImportToLib') && $hasRisklib;

$createLink      = $this->createLink('risk', 'create',      "projectID=$projectID&from=$from");
$batchCreateLink = $this->createLink('risk', 'batchCreate', "projectID=$projectID&from=$from");
$createItem      = array('text' => $lang->risk->create,      'url' => $createLink);
$batchCreateItem = array('text' => $lang->risk->batchCreate, 'url' => $batchCreateLink);

$app->tab != 'safe' ? toolbar(common::hasPriv('risk', 'export') ? btngroup
(
    dropdown(set::icon('export'), set::items(array(array('text' => $lang->risk->export, 'url' => createLink('risk', 'export', "objectID=$projectID&browseType=$browseType&orderBy=$orderBy"), 'data-toggle' => 'modal'))), btn(setClass('btn ghost dropdown-toggle'), $lang->export, setStyle(array('padding' => '6px', 'border-radius' => '0 2px 2px 0'))), set::placement('bottom-end'))
) : null, common::hasPriv('risk', 'importFromLib') && $hasRisklib ? btngroup
(
    dropdown(set::icon('export'), set::items(array(array('text' => $lang->risk->importFromLib, 'url' => createLink('risk', 'importFromLib', "projectID=$projectID&from=$from")))), btn(setClass('btn ghost dropdown-toggle'), $lang->import, setStyle(array('padding' => '6px', 'border-radius' => '0 2px 2px 0'))), set::placement('bottom-end'))
) : null, $canCreate && $canBatchCreate ? btngroup
(
    btn(setClass('btn primary'), set::icon('plus'), set::url($createLink), $lang->risk->create),
    dropdown(btn(setClass('btn primary dropdown-toggle'), setStyle(array('padding' => '6px', 'border-radius' => '0 2px 2px 0'))), set::items(array($createItem, $batchCreateItem)), set::placement('bottom-end'))
) : null, $canCreate && !$canBatchCreate ? item(set($createItem + array('class' => 'btn primary', 'icon' => 'plus'))) : null, $canBatchCreate && !$canCreate ? item(set($batchCreateItem + array('class' => 'btn primary', 'icon' => 'plus'))) : null) : null;

$footToolbar = array('items' => array
(
    array('text' => $lang->risk->importToLib, 'className' => 'primary batch-btn', 'url' => '#batchImportToLib', 'data-toggle' => 'modal', 'data-on' => 'click', 'data-call' => 'clickImportToLib'),
), 'btnProps' => array('size' => 'sm', 'btnType' => 'primary'));

$config->risk->dtable->fieldList['strategy']['map'] = $lang->risk->strategyList;

if($app->tab == 'safe')
{
    $config->risk->dtable->fieldList['team']['map'] = $teams;
    $config->risk->dtable->fieldList['name']['data-toggle'] = 'modal';
    $config->risk->dtable->fieldList['name']['data-size']   = 'lg';

    $effortIndex = array_search('effort', $config->risk->dtable->fieldList['actions']['menu']);
    unset($config->risk->dtable->fieldList['actions']['menu'][$effortIndex]);
}
else
{
    unset($config->risk->dtable->fieldList['team']);
}

$risks       = initTableData($risks, $config->risk->dtable->fieldList, $this->risk);
$pageSummary = str_replace('%total%', (string)count($risks), $lang->risk->pageSummary);
$pageSummary = str_replace('%active%', (string)$activeCount, $pageSummary);
$pageSummary = str_replace('%hangup%', (string)$hangupCount, $pageSummary);

dtable
(
    set::cols(array_values($config->risk->dtable->fieldList)),
    set::data(array_values($risks)),
    set::userMap($users),
    set::fixedLeftWidth('0.44'),
    set::orderBy($orderBy),
    set::sortLink(createLink('risk', 'browse', "projectID=$projectID&from=$from&browseType=$browseType&param=$param&orderBy={name}_{sortType}")),
    set::checkable($canBatchACtion),
    set::defaultSummary(array('html' => $pageSummary)),
    set::checkedSummary($lang->risk->checkedSummary),
    set::checkInfo($browseType == 'all' ? jsRaw('function(checkedIDList){return window.setStatistics(this, checkedIDList);}') : null),
    set::footToolbar($footToolbar),
    set::footPager(usePager())
);

modal
(
    set::id('batchImportToLib'),
    set::modalProps(array('title' => $lang->risk->importToLib)),
    formPanel
    (
        set::url(createLink('risk', 'batchImportToLib')),
        set::actions(array('submit')),
        set::submitBtnText($lang->import),
        formRow
        (
            formGroup
            (
                set::label($lang->risk->lib),
                picker
                (
                    set::name('lib'),
                    set::items($libs),
                    set::value(''),
                    set::required(true)
                )
            ),
            input(set::className('hidden'), set::name('riskIDList'), set::value(''))
        ),
        !common::hasPriv('assetlib', 'approveIssue') && !common::hasPriv('assetlib', 'batchApproveIssue') ? formRow
        (
            formGroup
            (
                set::label($lang->risk->approver),
                picker
                (
                    set::name('assignedTo'),
                    set::items('approvers'),
                    set::value('')
                )
            )
        ) : null
    )
);

render();
