<?php
/**
 * The view archived card view file of kanban module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Sun Guangming<wangyuting@easycorp.ltd>
 * @package     kanban
 * @link        https://www.zentao.net
 */
namespace zin;

$cardItems = array();
$pairs     = array();
foreach($requirements as $urID => $requirement)
{
    if(empty($requirement['stories'])) continue;

    $pairs[$urID] = $requirementPairs[$urID];
    if(!empty($requirementID) && $urID != $requirementID) continue;

    $cardItems[] = div
    (
        setID("requirement-{$urID}"),
        setClass('text-left font-bold requirement-title'),
        label(setClass('mr-1'), $gradeGroups['requirement'][$requirement['grade']]->name),
        $requirement['title'],
        icon('chevron-double-up')
    );
    foreach($requirement['stories'] as $storyId)
    {
        if(!isset($cards[$storyId])) continue;

        $card = $cards[$storyId];
        $assignedToList = explode(',', $card->assignedTo);

        $members       = '';
        $count         = 0;
        $beginAndEnd   = '';
        $assignedToBox = array();
        if(is_array($assignedToList))
        {
            foreach($assignedToList as $index => $account)
            {
                if(!isset($users[$account]) or !isset($usersAvatar[$account]))
                {
                    unset($assignedToList[$index]);
                    continue;
                }
                $members .= $users[$account] . ' ';
            }
            $userCount = count($assignedToList);

            if($userCount > 0)
            {
                foreach($assignedToList as $account)
                {
                    if($count > 2) continue;
                    $assignedToBox[] = userAvatar(set::avatar($usersAvatar[$account]), set::account($account), set::realname($users[$account]), set::size('sm'));
                    $count ++;
                }

                if($count > 2) $assignedToBox[] = span(setClass('font-bold'), '...');
            }
        }
        else
        {
            if(isset($usersAvatar[$assignedToList]) and isset($users[$assignedToList]))
            {
                $members .= $users[$assignedToList];
                $assignedToBox[] = userAvatar(set::avatar($usersAvatar[$assignedToList]), set::account($assignedToList), set::realname($users[$assignedToList]), set::size('sm'));
            }
        }

        $cardItems[] = div
        (
            setClass("card-list flex kanban-new-item requirement-{$urID} story-{$card->id}"),
            set::id($card->id),
            div
            (
                setClass('card'),
                div
                (
                    setClass('card-heading'),
                    label($gradeGroups[$card->type][$card->grade]->name),
                    a
                    (
                        set
                        (
                            array
                            (
                                'href'        => createLink('story', 'view', "cardID=$card->id"),
                                'data-toggle' => 'modal',
                                'data-size'   => 'lg',
                                'class'       => 'card-title'
                            )
                        ),
                        $card->title
                    )
                ),
                div
                (
                    setClass('card-content'),
                    div
                    (
                        setClass('flex items-center'),
                        span(setClass("pri-{$card->pri}"), $lang->story->priList[$card->pri]),
                        span(setClass('text-sm ml-2 mr-1'), $lang->story->estimateAB),
                        span(setClass('text-sm'), $card->estimate . 'h'),
                        div
                        (
                            setClass('flex-1 flex justify-end'),
                            set::title($members),
                            $assignedToBox
                        )
                    )
                )
            )
        );
    }
}

panel
(
    div
    (
        set::className('font-bold option-box-title'),
        $lang->pi->selectRequirement
    ),
    div
    (
        setClass('option-box'),
        picker
        (
            set::id('requirement'),
            set::name('requirement'),
            set::value($requirementID),
            set::items($pairs),
            on::change('changeBacklogList'),
            set::width(200)
        )
    ),
    $cardItems
);
