<?php
/**
 * The linkRequirement view file of pi module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yuting Wang <wangyuting@easycorp.ltd>
 * @package     pi
 * @link        https://www.zentao.net
 */
namespace zin;

jsVar('piID', $PI->id);
jsVar('columnID', $columnID);

$cols = array();
foreach($config->pi->defaultFields['linkrequirement'] as $field) $cols[$field] = \zget($config->pi->story->dtable->fieldList, $field, array());
$cols = array_map(function($col){$col['show'] = true; return $col;}, $cols);
$cols['title']['title']        = str_replace($lang->SRCommon, $lang->URCommon, $lang->story->title);
$cols['title']['link']         = $this->createLink('requirement', 'view', "storyID={id}");
$cols['title']['nestedToggle'] = false;
$cols['title']['data-toggle']  = 'modal';
$cols['title']['data-size']    = 'lg';
$cols['assignedTo']['type']    = 'user';
$cols['product']['map']        = $products;
unset($cols['plan']);
unset($cols['stage']);

set::title($lang->pi->linkRequirement);
set::bodyClass('linkrequirement-modal-body');

featureBar
(
    div(setClass('option-box ml-4'), span
    (
        set::className('flex items-center team-title mr-4'),
        $lang->pi->selectProduct
    ), picker(set::id('product'), set::name('product'), set::value($productID), set::items($products), set::required(true), on::change('changeOption'))),
    div(setClass('option-box ml-4 mr-4'), span
    (
        set::className('flex items-center team-title mr-4'),
        $lang->pi->toLane
    ), picker(set::id('toLane'), set::name('toLane'), set::value($toLane), set::items($toLanes), set::required(true), on::change('changeOption')))
);

formBase
(
    set::actions(''),
    dtable(
        set::id('linkRequirementList'),
        set::userMap($users),
        set::cols($cols),
        set::data(array_values($requirements)),
        set::onRenderCell(jsRaw('window.renderStoryCell')),
        set::orderBy($orderBy),
        set::sortLink(createLink('pi', 'linkRequirementToPlan', "piID={$PI->id}&productID=$productID&columnID={$columnID}&toLane=$toLane&orderBy={name}_{sortType}")),
        set::footToolbar(array('items' => array(array
        (
            'text'      => $lang->pi->linkRequirement,
            'btnType'   => 'primary',
            'className' => 'size-sm linkObjectBtn batch-btn',
            'data-type' => 'requirement',
            'data-url'  => inlink('linkRequirementToPlan', "piID={$PI->id}&productID=$productID&columnID={$columnID}&toLane=$toLane"),
        ))
        )),
        set::footPager(usePager(array
        (
            'recPerPage'  => $pager->recPerPage,
            'recTotal'    => $pager->recTotal,
            'linkCreator' => helper::createLink('pi', 'linkRequirementToPlan', "piID={$PI->id}&productID=$productID&columnID={$columnID}&toLane=$toLane&orderBy={$orderBy}&recTotal={$pager->recTotal}&recPerPage={recPerPage}&page={page}")
        ))))
);
