<?php
/**
 * The linkRequirement view file of pi module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Sun Guangming <sunguangming@easycorp.ltd>
 * @package     pi
 * @link        https://www.zentao.net
 */
namespace zin;

jsVar('gradeGroup', $gradeGroup);

$cols = array();
foreach($config->pi->defaultFields['linkrequirement'] as $field) $cols[$field] = \zget($config->pi->story->dtable->fieldList, $field, array());
$cols = array_map(function($col){$col['show'] = true; return $col;}, $cols);
$cols['title']['title']        = str_replace($lang->SRCommon, $lang->URCommon, $lang->story->title);
$cols['title']['link']         = $this->createLink('requirement', 'view', "storyID={id}");
$cols['title']['data-toggle']  = 'modal';
$cols['title']['data-size']    = 'lg';
$cols['assignedTo']['type']    = 'user';
$cols['product']['map']        = $products;

foreach($requirements as $story) $story->estimate = $story->estimate . $config->hourUnit;

dropmenu(set::tab('pi'), set::objectID($PI->id));

featureBar
(
    backBtn(set::className('mr-2'), set::icon('back'), set::back('pi-backlog'), $lang->goback),
    li(searchToggle(set::module('pistory'), set::open($browseType == 'bysearch')))
);

dtable
(
    set::id('linkStoryList'),
    set::userMap($users),
    set::cols($cols),
    set::orderBy($orderBy),
    set::sortLink(createLink('pi', 'linkrequirement', "id={$PI->id}&browseType=$browseType&param=$param&orderBy={name}_{sortType}")),
    set::data(array_values($requirements)),
    set::onRenderCell(jsRaw('window.renderStoryCell')),
    set::footToolbar(array('items' => array(array
        (
            'text'      => $lang->pi->linkRequirement,
            'btnType'   => 'primary',
            'className' => 'size-sm linkObjectBtn batch-btn',
            'data-type' => 'story',
            'data-url'  => inlink('linkRequirement', "id={$PI->id}&browseType=$browseType&param=$param&orderBy=$orderBy"),
        ))
    )),
    set::footer(array('checkbox', 'toolbar', array('html' => html::a(inlink('backlog', "id=$PI->id"), $lang->goback, '', "class='btn size-sm'")), 'flex', 'pager')),
    set::footPager(usePager())
);
