<?php
/**
 * The backlog file of pi module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Sun Guangming <sunguangming@easycorp.ltd>
 * @package     pi
 * @link        https://www.zentao.net
 */
namespace zin;

foreach($requirements as $requirement)
{
    $reviewers = '';
    if($requirement->reviewedBy)
    {
        foreach(explode(',', $requirement->reviewedBy) as $reviewer)
        {
            $reviewer = zget($users, $reviewer, '');
            if($reviewer) $reviewers .= $reviewer . ' ';
        }
    }
    $requirement->reviewedBy = $reviewers;
}

jsVar('orderBy', $orderBy);
jsVar('piID', $PI->id);
jsVar('gradeGroup', $gradeGroup);

dropmenu(set::tab('pi'), set::objectID($PI->id));

featureBar(set::current($browseType), set::linkParams("id={$PI->id}&browseType={key}&orderBy={$orderBy}&recTotal={$pager->recTotal}&recPerPage={$pager->recPerPage}"));

toolbar(hasPriv('pi', 'linkRequirement') ? item(set(array
(
    'icon'  => 'link',
    'text'  => $lang->pi->linkRequirement,
    'class' => 'btn primary',
    'url'   => createLink('pi', 'linkRequirement', "id={$PI->id}")
))) : null);

$cols = array();
foreach($config->pi->defaultFields['backlog'] as $field) $cols[$field] = zget($config->pi->story->dtable->fieldList, $field, array());
$cols = array_map(function($col){$col['show'] = true; return $col;}, $cols);
$cols['title']['title']        = str_replace($lang->SRCommon, $lang->URCommon, $lang->story->title);
$cols['title']['nestedToggle'] = true;
$cols['title']['data-toggle']  = 'modal';
$cols['title']['data-size']    = 'lg';
$cols['assignedTo']['type']    = 'user';
$cols['actions']['list']       = $config->pi->actionList;
$cols['actions']['menu']       = array('unlinkRequirement');
$cols['product']['map']        = $products;

foreach($requirements as $story) $story->estimate = $story->estimate . $config->hourUnit;
$requirements = initTableData($requirements, $cols, $this->pi);

dtable
(
    set::id('backlogList'),
    set::checkable(hasPriv('pi', 'batchUnlinkRequirement')),
    set::userMap($users),
    set::cols($cols),
    set::data(array_values($requirements)),
    set::onRenderCell(jsRaw('window.renderStoryCell')),
    set::plugins(array('sortable')),
    set::onSortEnd(jsRaw('window.onSortEnd')),
    set::orderBy($orderBy),
    set::sortLink(createLink('pi', 'backlog', "id={$PI->id}&browseType={$browseType}&orderBy={name}_{sortType}")),
    set::footToolbar(array('items' => array(array
        (
            'text'      => $lang->pi->unlinkRequirement,
            'btnType'   => 'primary',
            'className' => 'size-sm linkObjectBtn batch-btn',
            'data-type' => 'story',
            'data-url'  => inlink('batchUnlinkRequirement', "id={$PI->id}"),
        ))
    )),
    set::footPager(usePager())
);
