window.getColActions = function(col)
{
    if(!privs.canLinkStory && !privs.canLinkRequirement && !privs.canCreateMilestone && !privs.canCreateCard) return false;

    return [{
        type: 'dropdown',
        icon: 'expand-alt text-primary',
        caret: false,
        items: [
            privs.canLinkStory       ? {text: piLang.linkStory,       icon: 'link', url: $.createLink('pi', 'linkStory', 'piID=' + piID + '&columnID=' + col.id + '&from=plan'), 'data-toggle': 'modal', 'data-size' : 'lg'} : null,
            privs.canLinkRequirement ? {text: piLang.linkRequirement, icon: 'link', url: $.createLink('pi', 'linkRequirementToPlan', 'piID=' + piID + '&productID=0&columnID=' + col.id), 'data-toggle': 'modal', 'data-size' : 'lg'} : null,
            (privs.canLinkStory || privs.canLinkRequirement) && (privs.canCreateMilestone || privs.canCreateCard) ? {type: 'divider'} : null,
            privs.canCreateMilestone ? {text: piLang.createMilestone, icon: 'plus', url: $.createLink('pi', 'createMilestone', 'piID=' + piID + '&columnID=' + col.id), 'data-toggle': 'modal'} : null,
            privs.canCreateCard      ? {text: piLang.createCard,      icon: 'plus', url: $.createLink('pi', 'createCard',      'piID=' + piID + '&columnID=' + col.id), 'data-toggle': 'modal'} : null,
        ],
    }];
}

window.getItem = function(info)
{
    info.item.titleAttrs = {'className': 'line-clamp-1', 'title' : info.item.title}; // title的属性
    if(info.item.cardType == 'story' || info.item.cardType == 'requirement')
    {
        const storyType = info.item.cardType;
        if(privs.canViewStory)
        {
            info.item.titleUrl   = $.createLink(storyType, 'view', 'id=' + info.item.name);
            info.item.titleAttrs = {'data-toggle': 'modal', 'data-size' : 'lg', 'className': 'card-title line-clamp-1', 'title' : info.item.title}; // title的属性
        }

        const storyGrade = gradeGroups[storyType][info.item.grade];
        info.item.prefix = {html: "<span class='label'>" + storyGrade.name + "</span>"};

        info.item.icon = storyType == 'story' ? 'product' : 'person';
        let avatar = "<span class='avatar rounded-full size-xs ml-1 " + (info.item.uavatar ? 'primary' : 'bg-lighter text-canvas') + "'>" + (info.item.uavatar ? info.item.uavatar : "<i class='icon icon-person'></i>");
        if(privs.canAssignToStory) avatar = "<a href='" + $.createLink('story', 'assignTo', 'storyID=' + info.item.name + '&kanbanGroup=default&from=&storyType=story&columnID=' + info.item.col) + "' data-toggle='modal'>" + avatar + "</a>";

        info.item.footer = {html: "<div class='flex items-center'><span class='pri-" + info.item.pri + "'>" + info.item.pri + "</span><span class='text-sm ml-2 mr-1'>" + estimateLang + "</span><span class='text-sm'>" + info.item.estimate + hourUnit +"</span><div class='flex-1 flex justify-end'><span class='status-" + info.item.status + "'>" + info.item.statusLabel + "</span>" + avatar + "</div></div>"};
    }
    else if(info.item.cardType == 'milestone')
    {
        info.item.icon = 'flag';
        let avatar = "<span class='avatar rounded-full size-xs ml-1 " + (info.item.uavatar ? 'primary' : 'bg-lighter text-canvas') + "'>" + (info.item.uavatar ? info.item.uavatar : "<i class='icon icon-person'></i>");
        if(privs.canAssignToMilestone) avatar = "<a href='" + $.createLink('pi', 'assignToMilestone', 'id=' + info.item.name) + "' data-toggle='modal'>" + avatar + "</a>";

        info.item.footer = {html: "<div class='flex items-center'><span class='text-sm'>" + info.item.end + "</span><div class='flex-1 flex justify-end'><span class='status-" + info.item.status + "'>" + info.item.statusLabel + "</span>" + avatar + "</div></div>"};
    }
    else if(info.item.cardType == 'common')
    {
        if(privs.canViewCard)
        {
            info.item.titleUrl   = $.createLink('pi', 'viewCard', 'id=' + info.item.name);
            info.item.titleAttrs = {'data-toggle': 'modal', 'className': 'card-title line-clamp-1', 'title' : info.item.title};
        }

        let avatar = "<span class='avatar rounded-full size-xs ml-1 " + (info.item.uavatar ? 'primary' : 'bg-lighter text-canvas') + "'>" + (info.item.uavatar ? info.item.uavatar : "<i class='icon icon-person'></i>");
        info.item.footer = {html: "<div class='flex items-center'><span class='pri-" + info.item.pri + "'>" + info.item.pri + "</span><span class='text-sm ml-2 mr-1'>" + estimateLang + "</span><span class='text-sm'>" + info.item.estimate + hourUnit +"</span><div class='flex-1 flex justify-end'><span class='status-" + info.item.status + "'>" + info.item.statusLabel + "</span>" + avatar + "</div></div>" + '<div class="flex"><div class="circle progress mt-3" style="width:80%"><div class="progress-bar" style="width: ' + info.item.progress + '%"></div></div><div class="mt-2 ml-2">' + info.item.progress + '%' + '</div></div>'};
    }

    if(linkPairs.includes(info.item.id)) info.item.className = 'dependent';
}

window.getItemActions = function(item)
{
    if(item.cardType == 'milestone')
    {
        if(!privs.canEditMilestone && !privs.canDeleteMilestone) return false;

        return [{
            type: 'dropdown',
            icon: 'ellipsis-v text-primary',
            caret: false,
            items: [
                privs.canEditMilestone ?   {text: piLang.editMilestone,   icon: 'edit',  url: $.createLink('pi', 'editMilestone',   'id=' + item.name), 'data-toggle': 'modal'} : null,
                privs.canDeleteMilestone ? {text: piLang.deleteMilestone, icon: 'trash', url: $.createLink('pi', 'deleteMilestone', 'id=' + item.name + '&laneID=' + item.lane + '&columnID=' + item.col), 'data-confirm': piLang.milestone.confirmDelete, innerClass: 'ajax-submit'} : null
            ],
        }];
    }
    else if(item.cardType == 'story' || item.cardType == 'requirement')
    {
        if(!privs.canUnlinkStory) return false;

        const unlinkLang = item.cardType == 'story' ? piLang.unlinkStory : piLang.unlinkRequirement;
        let items = [{text: unlinkLang, icon: 'unlink', url: $.createLink('pi', 'unlinkStory', 'piID=' + piID + '&columnID=' + item.col + '&laneID=' + item.lane + '&storyID=' + item.cardID), 'data-confirm': piLang.notice.confirmUnlink, innerClass: 'ajax-submit'}];

        return [{
            type: 'dropdown',
            icon: 'ellipsis-v text-primary',
            caret: false,
            items: items
        }];
    }
    else if(item.cardType == 'common')
    {
        return [{
            type: 'dropdown',
            icon: 'ellipsis-v text-primary',
            caret: false,
            items: buildCardActions(item)
        }];
    }
}

window.getLaneActions = function(lane)
{
    if(!privs.canEditLane && !privs.canDeleteLane) return false;

    const items = [];
    if(privs.canEditLane)                            items.push({text: piLang.editLane,   icon: 'edit',  url: $.createLink('pi', 'editLane',   'id=' + lane.id), 'data-toggle': 'modal'});
    if(privs.canDeleteLane && lane.type == 'common') items.push({text: piLang.deleteLane, icon: 'trash', url: $.createLink('pi', 'deleteLane', 'id=' + lane.id), 'data-confirm': piLang.notice.confirmDeleteLane, innerClass: 'ajax-submit'});

    if(items.length == 0) return false;

    return [{
        type: 'dropdown',
        icon: 'ellipsis-v',
        caret: false,
        items: items
    }];
}

window.linkCard = function(info)
{
    linkPairs.push(info.from);// 动态追加连线关系
    if(!$('.card[z-key="' + info.from + '"]').hasClass('dependent')) $('.card[z-key="' + info.from + '"]').addClass('dependent');
    const url  = $.createLink('pi', 'linkCard', 'pi=' + piID + '&from=' + info.from + '&to=' + info.to);
    $.ajaxSubmit({url});

    info.deleted = false;
}

window.unlinkCard = function(info)
{
    /* 解决一个卡片被多个卡片依赖的情况，取消其中一个卡片，不会去掉颜色。*/
    let index = linkPairs.indexOf(info.from);
    if (index !== -1){
        linkPairs.splice(index, 1);
    }

    if($('.card[z-key="' + info.from + '"]').hasClass('dependent') && !linkPairs.includes(info.from)) $('.card[z-key="' + info.from + '"]').removeClass('dependent');
    const url  = $.createLink('pi', 'unlinkCard', 'pi=' + piID + '&from=' + info.from + '&to=' + info.to);
    $.ajaxSubmit({url});
}

window.buildCardActions = function(card)
{
    let actions = [];

    if(privs.canEditCard) actions.push({text: kanbanLang.editCard, icon: 'edit', url: $.createLink('pi', 'editCard', 'id=' + card.name), 'data-toggle': 'modal'});
    if(privs.canFinishCard && card.status != 'done') actions.push({text: kanbanLang.finishCard,   icon: 'checked', url: $.createLink('pi', 'finishCard', 'id=' + card.name), innerClass: 'ajax-submit'});
    if(privs.canActivateCard && (card.status == 'done' || card.status == 'closed')) actions.push({text: kanbanLang.activateCard, icon: 'magic', url: $.createLink('pi', 'activateCard', 'id=' + card.name), 'data-toggle': 'modal'});
    if(privs.canDeleteCard) actions.push({text: kanbanLang.deleteCard, icon: 'trash', url: $.createLink('pi', 'deleteCard', 'id=' + card.name + '&laneID=' + card.lane + '&columnID=' + card.col), 'data-confirm': piLang.notice.confirmDeleteCard, innerClass: 'ajax-submit'});

    return actions;
}
