<?php
public function getNavLang($type, $module, $method, $language = 'zh-cn', $defaultLang = null)
{
    if(empty($defaultLang)) $defaultLang = $this->loadDefaultLang($language);

    $menus = new stdclass();
    if($type == 'second')
    {
        if(isset($defaultLang->$module->homeMenu))
        {
            foreach($defaultLang->$module->homeMenu as $menuKey => $menu)
            {
                $menuKey = 'homeMenu_' . $menuKey;
                $menus->{$menuKey} = $menu;
            }
        }

        if(isset($defaultLang->$module->menu))
        {
            $menuList = $defaultLang->$module->menu;
            if(isset($defaultLang->$module->menuOrder)) $menuList->menuOrder = $defaultLang->$module->menuOrder;
            $menuList = $this->sortMenus($menuList);
            foreach($menuList as $menuKey => $menu)
            {
                if(is_array($menu) and !isset($menu['link'])) continue;

                $newKey = 'menu_' . $menuKey;
                $menus->{$newKey} = $menu;

                if(!isset($menu['dropMenu'])) continue;
                foreach($menu['dropMenu'] as $key => $menu)
                {
                    $dropMenuKey = $menuKey . 'DropMenu_' . $key;
                    $menus->{$dropMenuKey} = $menu;
                }
            }
        }

        /* SAFe append pi menu. */
        if($module == 'safe')
        {
            foreach($this->lang->pi->menu as $menuKey => $menu)
            {
                $menuKey = 'menu_' . $menuKey;
                $menus->{$menuKey} = $menu;
            }
        }
    }
    else
    {
        $menus = ($type == 'third' and isset($defaultLang->$module->menu->{$method}['subMenu'])) ? $defaultLang->$module->menu->{$method}['subMenu'] : $defaultLang->mainNav;
        if(!empty($module) and isset($defaultLang->$module->menu->{$method}['menuOrder'])) $menus->menuOrder = $defaultLang->$module->menu->{$method}['menuOrder'];
        $menus = $this->sortMenus($menus);
    }

    return $menus;
}
