<?php
/**
 * The browse view file of art module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Sun Guangming<sunguangming@easycorp.ltd>
 * @package     art
 * @link        https://www.zentao.net
 */
namespace zin;

featureBar(set::current($status), set::linkParams('status={key}'));

toolbar(common::hasPriv('art', 'create') ? btn(setClass('btn primary'), set::icon('plus'), set::url(inlink('create')), $lang->art->create) : '');

foreach($artList as $art)
{
    $productNames = '';
    if($art->product)
    {
        foreach(explode(',', $art->product) as $product)
        {
            $productName = zget($products, $product, '');
            if($productName) $productNames .= $productName . ' ';
        }
        $art->product = $productNames;
    }

    /* 显示业务负责人真实姓名。 */
    $managers = '';
    if($art->manager)
    {
        foreach(explode(',', $art->manager) as $manager) $managers .= zget($users, $manager) . ' ';
        $art->manager = $managers;
    }

    /* 显示产品经理真实姓名。 */
    $POList = '';
    if($art->PO)
    {
        foreach(explode(',', $art->PO) as $PO) $POList .= zget($users, $PO) . ' ';
        $art->PO = $POList;
    }

    /* 显示系统架构师真实姓名。 */
    $architects = '';
    if($art->architect)
    {
        foreach(explode(',', $art->architect) as $architect) $architects .= zget($users, $architect) . ' ';
        $art->architect = $architects;
    }
}

$artList = initTableData($artList, $config->art->dtable->fieldList, $this->art);

foreach($artList as $id => $art)
{
    foreach($art->actions as $actionID => $action)
    {
        if($action['name'] == 'delete' && $action['disabled']) $artList[$id]->actions[$actionID]['hint'] = $this->lang->art->notice->hasPI;
    }
}

dtable(
    set::cols(array_values($config->art->dtable->fieldList)),
    set::data(array_values($artList)),
    set::userMap($users),
    set::orderBy($orderBy),
    set::sortLink(createLink('art', 'browse', "status={$status}&orderBy={name}_{sortType}")),
    set::fixedLeftWidth('0.44'),
    set::onRenderCell(jsRaw('window.renderCell')),
    set::footPager(usePager())
);
