<?php
/**
 * The view view file of risk module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Sun Guangming <sunguangming@easycorp.ltd>
 * @package     risk
 * @link        https://www.zentao.net
 */
namespace zin;

$risk->execution = $risk->execution ? $risk->execution : $this->session->execution;
$risk->project   = $risk->project ? $risk->project : $this->session->project;
if($app->tab == 'execution')
{
    dropmenu(set::tab('execution'), set::objectID($risk->execution), set::url(createLink('execution', 'ajaxGetDropMenuData', "projectID={$risk->execution}&module=risk&method=browse")));
}
else if($app->tab == 'project')
{
    dropmenu(set::tab('project'), set::objectID($risk->project), set::url(createLink('project', 'ajaxGetDropMenuData', "projectID={$risk->project}&module=risk&method=browse")));
}

detailHeader
(
    to::title(entityLabel(set(array
    (
        'entityID' => $risk->id,
        'level' => 1,
    )), $risk->name), $risk->deleted ? span(set::className('label danger'), $lang->risk->deleted) : null)
);

$issueHtml = '';
if($from == 'pi')
{
    $effortIndex = array_search('effort', $config->risk->actions->view['mainActions']);
    $importIndex = array_search('importToLib', $config->risk->actions->view['mainActions']);
    unset($config->risk->actions->view['mainActions'][$effortIndex]);
    unset($config->risk->actions->view['mainActions'][$importIndex]);
}
else
{
    $hasViewIssuePriv = common::hasPriv('issue', 'view');
    foreach($linkedIssues as $issueID => $issue)
    {
        $issueTitle = "#$issueID {$issue->title}";
        $issueHtml  = $issueTitle;
        if($hasViewIssuePriv)
        {
            $issueLink  = $this->createLink('issue', 'view', "issueID=$issueID", '', true);
            $issueClass = isonlybody() ? '' : 'iframe';
            $issueHtml  = html::a($issueLink, $issueTitle, '', "class='$issueClass' data-width='80%'");
        }
        $issueHtml .= '<br />';
    }
}


$actionList = $this->loadModel('common')->buildOperateMenu($risk);

detailBody(sectionList(section
(
    set::title($lang->risk->prevention),
    set::content($risk->prevention),
    set::useHtml(true)
), section
(
    set::title($lang->risk->remedy),
    set::content($risk->remedy),
    set::useHtml(true)
), section
(
    set::title($lang->risk->resolution),
    set::content($risk->resolution),
    set::useHtml(true)
)), history(set::commentUrl(createLink('action', 'comment', array('objectType' => 'risk', 'objectID' => $risk->id)))), floatToolbar
(
    set::object($risk),
    isAjaxRequest('modal') ? null : to::prefix(backBtn(set::icon('back'), set::className('ghost text-white'), $lang->goback)),
    set::main($actionList['mainActions']),
    set::suffix($actionList['suffixActions'])
), detailSide(tabs(tabPane
(
    set::key('legendBasicInfo'),
    set::title($lang->risk->legendBasicInfo),
    set::active(true),
    tableData($from == 'pi' ? item
    (
        set::name($lang->risk->team),
        \zget($teams, $risk->team)
    ) : null, $from != 'pi' ? item
    (
        set::name($lang->risk->source),
        \zget($lang->risk->sourceList, $risk->source)
    ) : null, $from != 'pi' ? item
    (
        set::name($lang->risk->execution),
        isset($execution->name) ? $execution->name : ''
    ) : null, item
    (
        set::name($lang->risk->category),
        \zget($lang->risk->categoryList, $risk->category)
    ), item
    (
        set::name($lang->risk->strategy),
        \zget($lang->risk->strategyList, $risk->strategy)
    ), item
    (
        set::name($lang->risk->status),
        span
        (
            setClass("status-{$risk->status}"),
            \zget($lang->risk->statusList, $risk->status)
        )
    ), item
    (
        set::name($lang->risk->impact),
        \zget($lang->risk->impactList, $risk->impact)
    ), item
    (
        set::name($lang->risk->probability),
        \zget($lang->risk->probabilityList, $risk->probability)
    ), item
    (
        set::name($lang->risk->rate),
        $risk->rate
    ), item
    (
        set::name($lang->risk->pri),
        span(setClass("pri-{$risk->pri}"), \zget($lang->risk->priList, $risk->pri))
    ), item
    (
        set::name($lang->risk->assignedTo),
        \zget($users, $risk->assignedTo)
    ), item
    (
        set::name($lang->risk->identifiedDate),
        helper::isZeroDate($risk->identifiedDate) ? '' : $risk->identifiedDate
    ), item
    (
        set::name($lang->risk->plannedClosedDate),
        helper::isZeroDate($risk->plannedClosedDate) ? '' : $risk->plannedClosedDate
    ), item
    (
        set::name($lang->risk->actualClosedDate),
        helper::isZeroDate($risk->actualClosedDate) ? '' : $risk->actualClosedDate
    ))
), tabPane
(
    set::key('legendLifeTime'),
    set::title($lang->risk->legendLifeTime),
    tableData
    (
        item
        (
            set::name($lang->risk->createdBy),
            \zget($users, $risk->createdBy) . $lang->at . $risk->createdDate
        ),
        item
        (
            set::name($lang->risk->trackedBy),
            $risk->trackedBy ? \zget($users, $risk->trackedBy) . $lang->at . $risk->trackedDate : ''
        ),
        item
        (
            set::name($lang->risk->resolvedBy),
            \zget($users, $risk->resolvedBy)
        ),
        item
        (
            set::name($lang->risk->closedBy),
            $risk->closedBy ? \zget($users, $risk->closedBy) . $lang->at . $risk->closedDate : ''
        ),
        item
        (
            set::name($lang->risk->activateBy),
            $risk->activateBy ? \zget($users, $risk->activateBy) . $lang->at . $risk->activateDate : ''
        ),
        item
        (
            set::name($lang->risk->hangupBy),
            $risk->hangupBy ? \zget($users, $risk->hangupBy) . $lang->at . $risk->hangupDate : ''
        ),
        item
        (
            set::name($lang->risk->cancelBy),
            $risk->cancelBy ? \zget($users, $risk->cancelBy) . $lang->at . $risk->cancelDate : ''
        ),
        item
        (
            set::name($lang->risk->cancelReason),
            \zget($lang->risk->cancelReasonList, $risk->cancelReason)
        ),
        item
        (
            set::name($lang->risk->editedBy),
            $risk->editedBy ? \zget($users, $risk->editedBy) . $lang->at . $risk->editedDate : ''
        )
    )
)), $from != 'pi' ? tabs(tabPane
(
    set::key('legendMisc'),
    set::active(true),
    set::title($lang->risk->legendMisc),
    tableData
    (
        item
        (
            set::name($lang->risk->linkedIssues),
            html($issueHtml)
        )
    )
)) : null));

modal
(
    set::id('importToLib'),
    set::modalProps(array('title' => $lang->risk->importToLib)),
    formPanel
    (
        set::url(createLink('risk', 'importToLib', "risk=$risk->id")),
        set::actions(array('submit')),
        set::submitBtnText($lang->import),
        formRow
        (
            formGroup
            (
                set::label($lang->risk->lib),
                picker
                (
                    set::name('lib'),
                    set::items($libs),
                    set::value(''),
                    set::required(true)
                )
            )
        ),
        !common::hasPriv('assetlib', 'approveIssue') && !common::hasPriv('assetlib', 'batchApproveIssue') ? formRow
        (
            formGroup
            (
                set::label($lang->risk->approver),
                picker
                (
                    set::name('assignedTo'),
                    set::items('approvers'),
                    set::value('')
                )
            )
        ) : null
    )
);
