<?php
/**
 * The create view file of risk module of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Sun Guangming<sunguangming@easycorp.ltd>
 * @package     risk
 * @link        https://www.zentao.net
 */

namespace zin;

if($app->tab == 'execution')
{
    dropmenu(set::tab('execution'), set::objectID($executionID), set::url(createLink('execution', 'ajaxGetDropMenu', "projectID=$executionID&module=risk&method=browse")));
}
else if($app->tab == 'project')
{
    dropmenu(set::tab('project'), set::objectID($projectID), set::url(createLink('project', 'ajaxGetDropMenu', "projectID=$projectID&module=risk&method=browse")));
}

if($from != 'pi')
{
    $formRow[] = formRow(formGroup
    (
        set::label($lang->risk->name),
        set::required(true),
        set::width('1/2'),
        input(set::name('name'))
    ), formGroup
    (
        set::label($lang->risk->source),
        set::width('1/2'),
        picker(set::name('source'), set::items($lang->risk->sourceList))
    ));
    $formRow[] = formRow
    (
        formGroup
        (
            set::label($lang->task->execution),
            set::width('1/2'),
            picker(set::name('execution'), set::items($executions), set::value(isset($executionID) ? $executionID : ''))
        ),
        formGroup
        (
            set::label($lang->risk->assignedTo),
            set::width('1/2'),
            picker(set::name('assignedTo'), set::items($users))
        )
    );
}
else
{
    $formRow[] = formRow
    (
        formGroup
        (
            set::label($lang->risk->name),
            set::required(true),
            set::width('1/2'),
            input(set::name('name'))
        ),
        formGroup
        (
            set::label($lang->risk->assignedTo),
            set::width('1/2'),
            picker(set::name('assignedTo'), set::items($users))
        )
    );
}

formPanel(set::title($lang->risk->create), on::change('#impact', 'computeIndex'), on::change('#probability', 'computeIndex'), set::submitBtnText($lang->save), $formRow, formRow
(
    formGroup
    (
        set::label($lang->risk->category),
        set::width('1/2'),
        picker(set::name('category'), set::items($lang->risk->categoryList))
    ),
    formGroup
    (
        set::label($lang->risk->strategy),
        set::width('1/2'),
        picker(set::name('strategy'), set::items($lang->risk->strategyList))
    )
), formRow
(
    formGroup
    (
        set::label($lang->risk->impact),
        set::width('1/4'),
        picker(set::id('impact'), set::name('impact'), set::items($lang->risk->impactList), set::value(3))
    ),
    formGroup
    (
        set::label($lang->risk->probability),
        set::width('1/4'),
        picker(set::id('probability'), set::name('probability'), set::items($lang->risk->probabilityList), set::value(3))
    ),
    formGroup
    (
        set::label($lang->risk->rate),
        set::width('1/4'),
        input(set::id('rate'), set::name('rate'), set::value('9'), set::readonly(true))
    ),
    formGroup
    (
        set::label($lang->risk->pri),
        set::width('1/4'),
        priPicker
        (
            set::name('pri'),
            set::items($lang->risk->priList),
            set::value('middle'),
            set::readonly(true)
        )
    )
), formRow
(
    formGroup
    (
        set::label($lang->risk->identifiedDate),
        set::width('1/2'),
        datepicker(set::name('identifiedDate'))
    ),
    formGroup
    (
        set::label($lang->risk->plannedClosedDate),
        set::width('1/2'),
        datepicker(set::name('plannedClosedDate'))
    )
), $from != 'pi' ? formRow
(
    formGroup
    (
        set::label($lang->risk->issues),
        picker(set::name('issues'), set::items($issues), set::multiple(true))
    )
) : null, formRow
(
    formGroup
    (
        set::label($lang->risk->prevention),
        editor(set::name('prevention'))
    )
), formRow
(
    formGroup
    (
        set::label($lang->risk->remedy),
        editor(set::name('remedy'))
    )
));
