<?php
/**
 * The batchCreate view file of risk module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Sun Guangming<sunguangming@easycorp.ltd>
 * @package     risk
 * @link        https://www.zentao.net
 */
namespace zin;

if($app->tab == 'execution')
{
    dropmenu(set::tab('execution'), set::objectID($executionID), set::url(createLink('execution', 'ajaxGetDropMenuData', "projectID=$executionID&module=risk&method=browse")));
}
else if($app->tab == 'project')
{
    dropmenu(set::tab('project'), set::objectID($projectID), set::url(createLink('project', 'ajaxGetDropMenuData', "projectID=$projectID&module=risk&method=browse")));
}

formBatchPanel(set::title($lang->risk->batchCreate), formBatchItem(set::name('id'), set::label($lang->idAB), set::control('index'), set::width('32px')), formBatchItem(set::name('execution'), set::label($lang->risk->execution), set::control('picker'), set::items($executions), set::width('200px'), set::ditto(true), isset($executionID) ? set::value($executionID) : null), formBatchItem(set::name('name'), set::required(true), set::label($lang->risk->name)), formBatchItem(set::name('source'), set::label($lang->risk->source), set::control('picker'), set::items($lang->risk->sourceList), set::width('160px'), set::ditto(true)), formBatchItem(set::name('category'), set::label($lang->risk->category), set::control('picker'), set::items($lang->risk->categoryList), set::width('160px'), set::ditto(true)), formBatchItem(set::name('strategy'), set::label($lang->risk->strategy), set::control('picker'), set::items($lang->risk->strategyList), set::width('160px'), set::ditto(true)));
