<?php
/**
 * The team view file of pi module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yuting Wang <wangyuting@easycorp.ltd>
 * @package     pi
 * @link        https://www.zentao.net
 */
namespace zin;
$app->loadLang('objective');

$privs = array
(
    'canSetCapacity'     => common::hasPriv('pi', 'setCapacity'),
    'canEditLane'        => common::hasPriv('pi', 'editLane'),

    'canCreateRisk'      => common::hasPriv('risk', 'create'),
    'canEditRisk'        => common::hasPriv('risk', 'edit'),
    'canViewRisk'        => common::hasPriv('risk', 'view'),
    'canCloseRisk'       => common::hasPriv('risk', 'close'),
    'canActivateRisk'    => common::hasPriv('risk', 'activate'),
    'canDeleteRisk'      => common::hasPriv('risk', 'delete'),
    'canMoveCard'        => common::hasPriv('pi', 'moveCard'),

    'canCreateStory'     => common::hasPriv('story', 'create'),
    'canViewStory'       => common::hasPriv('story', 'view'),
    'canAssignToStory'   => common::hasPriv('story', 'assignTo'),
    'canLinkStory'       => common::hasPriv('pi', 'linkStory'),
    'canUnlinkStory'     => common::hasPriv('pi', 'unlinkStory'),

    'canCreateObjective' => common::hasPriv('objective', 'create'),
    'canEditObjective'   => common::hasPriv('objective', 'edit'),
    'canDeleteObjective' => common::hasPriv('objective', 'delete'),
);

$products = explode(',', $PI->product);
$product  = reset($products);

jsVar('piID',             $PI->id);
jsVar('kanbanType',       'teamkanban');
jsVar('product',          $product);
jsVar('hourUnit',         $config->hourUnit);
jsVar('confirmUnlink',    $lang->pi->notice->confirmUnlinkStory);
jsVar('editLabel',        $lang->edit);
jsVar('createStory',      $lang->pi->createStory);
jsVar('linkStory',        $lang->pi->linkStory);
jsVar('unlinkStory',      $lang->pi->unlinkStory);
jsVar('workhourLabel',    $lang->pi->workhour);
jsVar('capacityLabel',    $lang->pi->capacity);
jsVar('workloadLabel',    $lang->pi->workload);
jsVar('editObjective',    $lang->objective->edit);
jsVar('deleteObjective',  $lang->objective->delete);
jsVar('confirmDelete',    $lang->objective->notice->confirmDelete);
jsVar('confirmMoveStory', $lang->pi->notice->confirmMoveStory);
jsVar('riskLang',         $lang->risk);
jsVar('estimateLang',     $lang->story->estimateAB);
jsVar('editLane',         $lang->pi->editLane);
jsVar('featuresLang',     $lang->pi->features);
jsVar('privs',            $privs);
jsVar('teamID',           $teamID);
jsVar('gradeGroups',      $gradeGroups);

dropmenu(set::tab('pi'), set::objectID($PI->id));

$teamItems = array();
$teamItems[] = array('text' => $lang->all, 'active' => !$teamID, 'url' => $this->createLink('pi', 'team', "id={$PI->id}&teamID=0"));
foreach($teams as $currentID => $team) $teamItems[] = array('text' => $team, 'active' => $currentID == $teamID, 'hint' => $team, 'url' => $this->createLink('pi', 'team', "id={$PI->id}&teamID={$currentID}"));

featureBar(dropdown
(
    setClass('mr-2'),
    btn
    (
        setClass('ghost'),
        \zget($teams, $teamID, $lang->all)
    ),
    set::items($teamItems)
), div(set::className('border circle bg-white'), btn(set::className('ghost square size-xs m-2 minus'), set('disabled', true), icon('minus', set::className('circle border scale-120')), set('data-on', 'click'), set('data-call', 'changeCardSize'), set('data-params', 'event')), span(set::className('px-2'), set::id('cardsize'), 1), btn(set::className('ghost square size-xs m-2 plus'), icon('plus', set::className('circle border scale-120')), set('data-on', 'click'), set('data-call', 'changeCardSize'), set('data-params', 'event'))));

toolbar
(
    common::hasPriv('pi', 'setKanban') ? item
    (
        set
        (
            array
            (
                'text'  => $lang->pi->setKanban,
                'url'   => $this->createLink('pi', 'setKanban', "kanban=$PI->teamkanban"),
                'icon'  => 'cog',
                'class' => 'btn primary',
                'data-toggle' => 'modal'
            )
        )
    ) : null,
    common::hasPriv('pi', 'initExecution') ? item
    (
        set
        (
            array
            (
                'text'  => $lang->pi->initExecution,
                'url'   => $this->createLink('pi', 'initExecution', "id=$PI->id&team=$teamID"),
                'icon'  => 'play',
                'class' => 'btn primary',
                'data-toggle' => 'modal',
                'data-backdrop' => 'static'
            )
        )
    ) : null
);

$kanbanList = array();
foreach($kanban as $groupID => $kanbanData)
{
    $kanbanItem = array();
    $kanbanItem['key']           = "group{$groupID}";
    $kanbanItem['colWidth']      = $kanbanData['colWidth'];
    $kanbanItem['laneHeight']    = $kanbanData['laneHeight'];
    $kanbanItem['data']          = $kanbanData;
    $kanbanItem['onDropNewItem'] = jsRaw('window.onDropNewItem');
    $kanbanItem['onDrop']        = jsRaw('window.onDrop');
    $kanbanItem['canDrop']       = jsRaw('window.canDrop');
    $kanbanItem['getItem']       = jsRaw('window.getItem');
    $kanbanItem['getCol']        = jsRaw('window.getCol');
    $kanbanItem['getLane']       = jsRaw('window.getLane');
    $kanbanItem['colProps']      = array('actions' => jsRaw('window.getColActions'));
    $kanbanItem['itemProps']     = array('actions' => jsRaw('window.getItemActions'));
    $kanbanItem['laneProps']     = array('actions' => jsRaw('window.getLaneActions'));

    if($privs['canMoveCard']) $kanbanItem['draggable'] = array('dragContainer' => '#kanban-container');

    if(!empty($kanbanData['minColWidth']))   $kanbanItem['minColWidth']   = $kanbanData['minColWidth'];
    if(!empty($kanbanData['maxColWidth']))   $kanbanItem['maxColWidth']   = $kanbanData['maxColWidth'];
    if(!empty($kanbanData['minLaneHeight'])) $kanbanItem['minLaneHeight'] = $kanbanData['minLaneHeight'];
    if(!empty($kanbanData['maxLaneHeight'])) $kanbanItem['maxLaneHeight'] = $kanbanData['maxLaneHeight'];
    $kanbanList[] = $kanbanItem;
}

div
(
    set::className('p-4 flex'),
    set::id('kanban-container'),
    div(set::id('backlog'), set::className('opened')),
    common::hasPriv('pi', 'viewBacklog') ? div(set::className('sidebar-toggle'), icon('angle-left')) : null,
    div
    (
        setClass('min-w-0'),
        zui::kanbanList
        (
            set('$replace', false),
            set::key('teamKanban'),
            set::items($kanbanList),
            set::height('calc(100vh - 120px)')
        )
    )
);

render();
