<?php
/**
 * The init execution view file of PI module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Sun Guangming <wangyuting@easycorp.ltd>
 * @package     PI
 * @link        https://www.zentao.net
 */
namespace zin;

jsVar('newProject', $lang->pi->newProject);
jsVar('piID', $piID);
jsVar('choseProject', $lang->pi->notice->choseProject);

modalHeader
(
    set::title($lang->pi->initExecution),
    set::titleClass('modal-title'),
    to::suffix
    (
        span(setClass('flex gap-x-2 ml-3'), html(\sprintf($lang->pi->notice->initExecution, count($teamPairs))))
    )
);

$executionGroup = array();
foreach($executions as $index => $execution)
{
    $executionGroup[] = formRow
    (
        formGroup
        (
            setClass('executions'),
            inputGroup
            (
                span(setClass('input-group-addon required'), $lang->pi->execution),
                input(set::name("execution[$index]"), set::value($execution->name)),
                span(setClass('input-group-addon'), $lang->execution->beginAndEnd),
                inputControl
                (
                    input(set::name("begin[$index]"), set::readonly(true), set::value($execution->begin)), to::suffix(icon('calendar'))
                ),
                span(setClass('input-group-addon'), $lang->execution->to),
                inputControl
                (
                    input(set::name("end[$index]"), set::readonly(true), set::value($execution->end)), to::suffix(icon('calendar'))
                ),
                div(setClass('pl-2 flex self-center line-btn'), btn(setClass('btn ghost removeLine'), icon('trash')))
            )
        )
    );
}

!empty($executions) ? formPanel
(
    on::change('[name=newProject]', 'addProject'),
    on::click('.removeLine', 'removeLine'),
    formGroup(setClass('only-label'), span($lang->pi->notice->choseTeam)),
    formGroup
    (
        picker(set::required(true), set::name('team'), set::items($teamPairs), set::value($teamID), on::change('changeTeam'))
    ),
    formGroup(setClass('only-label'), span
    (
        setClass('project-label'),
        $lang->pi->notice->choseProject
    )),
    formGroup
    (
        inputGroup
        (
            div
            (
                set::id('projectPicker'),
                setClass('grow'),
                picker(set::required(true), set::name('project'), set::items($projects))
            ),
            div
            (
                set::id('projectName'),
                setClass('grow hidden'),
                input(set::name('projectName'))
            ),
            common::hasPriv('project', 'create') ? div
            (
                setClass('flex items-center pl-2 clip'),
                checkbox(set::name('newProject'), set::text($lang->pi->newProject))
            ) : null
        )
    ),
    formGroup(setClass('only-label'), span($lang->pi->notice->createExecution)),
    div(set::id('executions'), $executionGroup)
) :
div
(
    set::className('alert with-icon'),
    div
    (
        set::className('content'),
        p(set::className('font-bold'), $lang->pi->notice->allComplete)
    )
);
