<?php
global $config;

if($config->vision == 'rnd')
{
    $lang->safe        = new stdclass();
    $lang->pi          = new stdclass();
    $lang->art         = new stdclass();
    $lang->objective   = new stdclass();

    $lang->safe->common       = 'SAFe';
    $lang->safe->todo         = 'PI Backlog';
    $lang->safe->team         = 'PI Team Kanban';
    $lang->safe->plan         = 'PI Plan Kanban';
    $lang->safe->risk         = 'PI Risk';
    $lang->art->common        = 'ART';
    $lang->pi->common         = 'PI';
    $lang->team->common       = 'Team';
    $lang->objective->common  = 'PI Objective';

    $lang->navIcons['safe'] = "<i class='icon icon-safe'></i>";
    $lang->navIconNames['safe'] = 'safe';
    $lang->mainNav->safe = "{$lang->navIcons['safe']} {$lang->safe->common}|art|browse|";

    if($config->vision != 'lite') $lang->mainNav->menuOrder[14] = 'safe';

    $lang->safe->menu = new stdclass();
    $lang->safe->menu->art       = array('link' => "ART|art|browse|");
    $lang->safe->menu->pi        = array('link' => "PI|pi|browse|");
    $lang->safe->menu->teamgroup = array('link' => "{$lang->team->common}|team|browse|");

    $lang->pi->menu = new stdclass();
    $lang->pi->menu->team      = array('link' => "{$lang->safe->team}|pi|team|id=%s");
    $lang->pi->menu->todo      = array('link' => "{$lang->safe->todo}|pi|backlog|id=%s", 'alias' => 'linkrequirement,backlog');
    $lang->pi->menu->plan      = array('link' => "{$lang->safe->plan}|pi|plan|id=%s");
    $lang->pi->menu->objective = array('link' => "{$lang->objective->common}|objective|browse|piID=%s", 'subModule' => 'objective');
    $lang->pi->menu->risk      = array('link' => "{$lang->safe->risk}|risk|browse|projectID=%s&from=safe");

    $lang->pi->dividerMenu = ',todo,';

    $lang->pi->menuOrder[5]  = 'team';
    $lang->pi->menuOrder[10] = 'todo';
    $lang->pi->menuOrder[15] = 'plan';
    $lang->pi->menuOrder[20] = 'objective';
    $lang->pi->menuOrder[25] = 'risk';

    $lang->navGroup->art       = 'safe';
    $lang->navGroup->pi        = 'safe';
    $lang->navGroup->objective = 'safe';
    $lang->navGroup->team      = 'system';

    /* System menu. */
    $lang->system->menu->dept    = array('link' => "{$lang->dept->common}|my|team|", 'subModule' => 'user');
    $lang->system->menu->team    = array('link' => "{$lang->team->common}|team|browse|");
    $lang->system->menu->dynamic = array('link' => "$lang->dynamic|company|dynamic|");
    $lang->system->menu->view    = array('link' => "{$lang->company->common}|company|view");

    /* System menu order. */
    $lang->system->menuOrder[5]  = 'dept';
    $lang->system->menuOrder[13] = 'team';
    $lang->system->menuOrder[14] = 'effort';
    $lang->system->menuOrder[15] = 'calendar';
    $lang->system->menuOrder[20] = 'dynamic';
    $lang->system->menuOrder[25] = 'view';
}
