<?php
public function processTrash($trash, $projectList, $productList, $executionList)
{
    if($trash->objectType == 'pivot')
    {
        $pivotNames = json_decode($trash->objectName, true);
        $trash->objectName = zget($pivotNames, $this->app->getClientLang(), '') ? : reset(array_filter($pivotNames));
    }
    else
    {
        $module     = $trash->objectType == 'case' ? 'testcase'                      : $trash->objectType;
        $params     = $trash->objectType == 'user' ? "account={$trash->objectName}" : "id={$trash->objectID}";
        $methodName = 'view';
        if($module == 'basicmeas')
        {
            $module     = 'measurement';
            $methodName = 'setSQL';
            $params     = "id={$trash->objectID}";
        }
        if($module == 'deploystep')
        {
            $module     = 'deploy';
            $methodName = 'viewStep';
        }
        if($trash->objectType == 'api')
        {
            $params     = "libID=0&moduelID=0&apiID={$trash->objectID}";
            $methodName = 'index';
        }
        if($trash->objectType == 'doc')
        {
            $params = "docID={$trash->objectID}";
        }
        if(in_array($module, array('traincourse','traincontents')))
        {
            $methodName = $module == 'traincourse' ? 'viewcourse' : 'viewchapter';
            $module     = 'traincourse';
        }
        if(isset($this->config->action->customFlows[$trash->objectType]))
        {
            $flow   = $this->config->action->customFlows[$trash->objectType];
            $module = $flow->module;
        }
        if(strpos($this->config->action->noLinkModules, ",{$module},") === false)
        {
            $tab     = '';
            $canView = common::hasPriv($module, $methodName);
            if($trash->objectType == 'meeting') $tab = $trash->project ? "data-app='project'" : "data-app='my'";
            $trash->objectName = $canView ? html::a($this->createLink($module, $methodName, $params), $trash->objectName, '_self', "title='{$trash->objectName}' data-toggle='modal' $tab") : "<span title='$trash->objectName'>$trash->objectName</span>";
        }
    }

    if(!empty($projectList[$trash->project]))     $trash->project   = $projectList[$trash->project]->name          . ($projectList[$trash->project]->deleted         ? "<span class='label danger ml-2'>{$this->lang->project->deleted}</span>" : '');
    if(!empty($productList[$trash->objectID]))    $trash->product   = $productList[$trash->objectID]->productTitle . ($productList[$trash->objectID]->productDeleted ? "<span class='label danger ml-2'>{$this->lang->story->deleted}</span>" : '');
    if(!empty($executionList[$trash->execution])) $trash->execution = $executionList[$trash->execution]->name      . ($executionList[$trash->execution]->deleted     ? "<span class='label danger ml-2'>{$this->lang->execution->deleted}</span>" : '');
}
