<?php
$this->loadModel('upgrade');

$versionList = array('1.0.1', '2.2', '2.3', '2.5', '2.6', '2.7');
$appList     = array('2.2' => 'GitFox', '2.5' => 'Spug', '2.6' => 'app-market');
foreach($versionList as $version)
{
    if(version_compare($this->post->installedVersion, $version, '<='))
    {
        $extensionPath = $this->app->getExtensionRoot() . 'pkg' . DS  . $extension . DIRECTORY_SEPARATOR . 'db' . DS . 'update' . $version . '.sql';
        if(file_exists($extensionPath)) $this->upgrade->execSQL($extensionPath);

        /* Install system app. */
        if(isset($appList[$version])) $this->upgrade->checkAndInstallServer($appList[$version]);
    }
}

/* Upgrade screen and metric data. */
if(version_compare($this->post->installedVersion, '2.7', '<='))
{
    if($this->config->inQuickon)
    {
        $extensionPath = $this->app->getExtensionRoot() . 'pkg' . DS  . $extension . DIRECTORY_SEPARATOR . 'db' . DS . 'screen.sql';
        $this->upgrade->execSQL($extensionPath);
    }

    $this->upgrade->upgradeScreenAndMetricData();
}
