<?php
/**
 * The set commit rule view file of repo module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yang Li <liyang@chandao.com>
 * @package     repo
 * @link        https://www.zentao.net
 */
namespace zin;
include 'sidebar.html.php';

form
(
    setClass('flex-auto canvas panel-body pb-8'),
    set::actionsClass('w-1/2'),
    set::actions(array('submit')),
    span(setClass('text-md font-bold'), $lang->repo->commitRule->rules['pr']),
    formGroup
    (
        set::width('1/3'),
        set::label($lang->repo->rule->setCodeReview),
        set::labelWidth(common::checkNotCN() ? '140px' : '120px'),
        radioList
        (
            set::name('codeReview'),
            set::items($lang->repo->rule->setCodeReviewList),
            set::value($ztFlowEnabled),
            set::inline(true)
        )
    ),
    formGroup
    (
        on::change('[name=pushLimitEnabled]')->call('changeRule'),
        set::width('1/3'),
        set::label($lang->repo->rule->setPushLimitEnabled),
        set::labelWidth(common::checkNotCN() ? '140px' : '120px'),
        radioList
        (
            set::name('pushLimitEnabled'),
            set::items($lang->repo->rule->setPushLimitEnabledList),
            set::value($pushLimitEnabled),
            set::inline(true)
        )
    ),
    div
    (
        setID('pushLimitInfo'),
        setClass($pushLimitEnabled ? '' : 'hidden'),
        formGroup
        (
            set::width('1/2'),
            set::className('mb-2'),
            set::labelWidth(common::checkNotCN() ? '140px' : '120px'),
            set::name("pushLimitTotalLines"),
            set::label($lang->repo->rule->setPushLimitTotalLines),
            set::required(false),
            set::value($pushLimitTotalLines),
        )
    ),
    formGroup
    (
        set::width('1/3'),
        set::label($lang->repo->rule->setRequireFitClient),
        set::labelWidth(common::checkNotCN() ? '140px' : '120px'),
        radioList
        (
            set::name('requireFitClient'),
            set::items($lang->repo->rule->setRequireFitClientList),
            set::value($requireFitClient),
            set::inline(true)
        )
    ),
    div
    (
        icon('info text-warning mr-2 ml-10'),
        $lang->repo->rule->setZtFlowAndRequireFitNotice
    ),
    div
    (
        setID('downloadFit'),
        span(setClass('ml-10 mr-2'), $lang->downloadFit),
        a
        (
            setID('downloadFit'),
            set::href(createLink('misc', 'ajaxDownloadFit', 'action=check&os=&repoID=' . $repoID)),
            set('data-toggle', 'modal'),
            common::getSysURL() . createLink('misc', 'ajaxDownloadFit', 'action=check&os=&repoID=' . $repoID)
        )
    )
);
