<?php
/**
 * The set commit rule view file of repo module of ZenTaoPMS.
 * @copyright   Copyright 2009-2024 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      XiQuan Zhang <zhangxiquan@chandao.com>
 * @package     repo
 * @link        https://www.zentao.net
 */
namespace zin;
include 'sidebar.html.php';

form
(
    setClass('flex-auto canvas panel-body pb-8'),
    set::actionsClass('w-1/2'),
    set::actions(array('submit')),
    span
    (
        setClass('text-md font-bold'),
        $lang->repo->commitRule->rules['cm']
    ),
    formGroup
    (
        on::change('[name=commitLimitEnabled]')->call('changeRule'),
        set::width('1/3'),
        set::label($lang->repo->rule->setCommitLimitEnabled),
        set::labelWidth(common::checkNotCN() ? '140px' : '120px'),
        radioList
        (
            set::name('commitLimitEnabled'),
            set::items($lang->repo->rule->setCommitLimitEnabledList),
            set::value($commitLimitEnabled),
            set::inline(true)
        )
    ),
    div
    (
        icon('info text-warning mr-2 ml-10'),
        $lang->repo->rule->setCommitLimitEnabledNotice
    ),
    div
    (
        setID('commitLimitInfo'),
        setClass($commitLimitEnabled ? '' : 'hidden'),
        formGroup
        (
            set::width('1/2'),
            set::className('mb-2'),
            set::labelWidth(common::checkNotCN() ? '160px' : '120px'),
            set::name("commitLimitTotalLines"),
            set::label($lang->repo->rule->setCommitLimitTotalLines),
            set::required(false),
            set::value($commitLimitTotalLines),
        )
    )
);
