<?php
namespace zin;

global $lang;

$fields = defineFieldList('repo.editrule', 'repo');

$fields->field('name')->control('input')->width('1/2')->value(data('rule.identifier'))->readonly(true)->required();
$fields->field('desc')->control('input')->width('1/2')->value(data('rule.description'));

$fields->field('include')->wrapBefore()->width('full')
    ->label($lang->repo->rule->pattern)
    ->checkbox(array('name' => 'default', 'text' => $lang->repo->rule->defaultPattern, 'value' => 1, 'disabled' => data('hasBuiltInRules'), 'checked' => !empty(data('rule.pattern')) && !empty(data('rule.pattern.default'))))
    ->control(array
    (
        'control' => 'inputGroup',
        'items' => array
        (
            $lang->repo->rule->include,
            array('control' => 'input', 'name' => 'include', 'value' => !empty(data('rule.pattern.include')) ? implode(',', data('rule.pattern.include')) : '')
        )
    ));

$fields->field('exclude')
    ->control(array
    (
        'control' => 'inputGroup',
        'items' => array
        (
            $lang->repo->rule->exclude,
            array('control' => 'input', 'name' => 'exclude', 'value' => !empty(data('rule.pattern.exclude')) ? implode(',', data('rule.pattern.exclude')) : '')
        )
    ))
    ->width('full')
    ->tip($lang->repo->rule->patternTip);

$fields->field('user')
    ->label($lang->repo->rule->switchUser)
    ->className(data('hasSystem') ? '' : 'hidden')
    ->checkbox(array('name' => 'bypass', 'text' => $lang->repo->rule->byPassRuleTip, 'value' => 1, 'checked' => !empty(data('rule.definition.bypass') && !empty(data('rule.definition.bypass.repo_owners')))))
    ->control('picker')
    ->multiple(true)
    ->value(!empty(data('rule.definition.bypass.user_ids')) ? data('rule.definition.bypass.user_ids') : array())
    ->items(data('users'))
    ->width('1/2');

$hiddenRule = array('require_minimum_count', 'require_code_owners', 'require_latest_commit', 'require_no_change_request', 'require_resolve_all', 'require_identifiers', 'strategies_allowed');
foreach($lang->repo->rule->ruleList as $ruleType => $rules)
{
    $definitionType = $ruleType == 'lifecycle' ? 'lifecycle' : 'pullreq';
    foreach($rules as $rule => $name)
    {
        $isChecked = !empty(data("rule.definition.{$definitionType}.{$ruleType}.{$rule}")) || !empty(data("rule.definition.{$ruleType}.{$rule}"));
        $fields->field($rule)
            ->wrapBefore()
            ->label($rule == 'update_forbidden' ? $lang->repo->rule->allRule : null)
            ->className(in_array($rule, $hiddenRule) ? 'hidden' : '')
            ->control(array('type' => 'checkbox', 'name' => $rule, 'text' => $name, 'checked' => $isChecked, 'value' => 1))
            ->id($rule)
            ->value(1)
            ->disabled(data('hasBuiltInRules') && in_array($rule, array('update_forbidden', 'create_forbidden', 'delete_forbidden', 'require_minimum_count', 'transfer_forbidden', 'require_latest_commit')))
            ->tip($lang->repo->rule->ruleListTip[$rule])
            ->width('1/2');

        if($rule == 'require_minimum_count' && !empty(data('rule.definition.pullreq.approvals.require_minimum_count')))
        {
            $fields->field('require_minimum_count_number')
                ->wrapBefore()
                ->label($lang->repo->rule->minRequireCount)
                ->className('hidden')
                ->controlBegin('input')
                ->id('require_minimum_count_number')
                ->type('number')
                ->min(1)
                ->value(empty(data('rule.definition.pullreq.approvals.require_minimum_count')) ? 1 : data('rule.definition.pullreq.approvals.require_minimum_count'))
                ->controlEnd()
                ->width('1/2');
        }

        if($rule == 'require_identifiers')
        {
            $fields->field('pipeline')
                ->wrapBefore()
                ->label($lang->repo->rule->checkStatus)
                ->control('picker')
                ->id('pipeline')
                ->className('hidden')
                ->multiple(true)
                ->items(data('pipelineList'))
                ->value(!empty(data('rule.definition.pullreq.status_checks.require_identifiers')) ? data('rule.definition.pullreq.status_checks.require_identifiers') : array())
                ->width('1/2');
        }

        if($rule == 'strategies_allowed')
        {
            $fields->field('mergeType')
                ->wrapBefore()
                ->control('picker')
                ->id('mergeType')
                ->className('hidden')
                ->multiple(true)
                ->items($lang->repo->rule->mergeList)
                ->value(!empty(data('rule.definition.pullreq.merge.strategies_allowed')) ? data('rule.definition.pullreq.merge.strategies_allowed') : array())
                ->width('1/2');
        }
    }
}
