<?php
/**
 * The yyy view file of xxx module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yang Li <liyang@chandao.com>
 * @package     xxx
 * @link        https://www.zentao.net
 */
namespace zin;

formPanel
(
    set::title($lang->repo->createWebhook),
    formGroup
    (
        set::width('1/2'),
        set::name("name"),
        set::label($lang->repo->name),
        set::required(true),
    ),
    formRow
    (
        formGroup
        (
            set::width('1/2'),
            set::name("targetURL"),
            set::label($lang->repo->targetURL),
            set::required(true),
        ),
        formGroup
        (
            set::width('1/2'),
            setClass('items-center'),
            checkbox
            (
                set::name("SSL"),
                set::rootClass('ml-4'),
                set::value(0),
                set::text($lang->repo->webhook->SSL),
            )
        )
    ),
    formGroup
    (
        set::width('1/2'),
        set::name("key"),
        set::label($lang->repo->webhook->key),
        set::control(array('type' => 'password'))
    ),
    formGroup
    (
        set::width('1/2'),
        setID("triggerEvent"),
        set::name("triggerEvent"),
        set::label($lang->repo->webhook->triggerEvent),
        set::required(true),
        set::control('radioListInline'),
        set::items($lang->repo->webhook->triggerEventList),
        set::value(0),
        on::change()->call('onChangeTriggerEvent')
    ),
    formGroup
    (
        set::width('1/2'),
        setID("customEvent"),
        set::name("customEvent"),
        setClass('hidden'),
        set::label($lang->repo->webhook->customEvent),
        set::control('picker'),
        set::multiple(true),
        set::items($lang->repo->webhook->customEventList)
    ),
    formGroup
    (
        set::width('1/2'),
        set::name("desc"),
        set::label($lang->repo->webhook->desc),
        set::control(array('type' => 'textarea', 'rows' => 5))
    )
);
