<?php
$config->repo->notSyncSCM[]         = 'GitFox';
$config->repo->gitTypeList[]        = 'GitFox';
$config->repo->gitServiceList[]     = 'gitfox';
$config->repo->gitServiceTypeList[] = 'GitFox';

$config->repo->gitfox = new stdclass;
$config->repo->gitfox->apiPath = "%s/api/v1/repos/%s/+/";

$config->repo->dtable->tag->fieldList['actions']['name']  = 'actions';
$config->repo->dtable->tag->fieldList['actions']['title'] = $lang->actions;
$config->repo->dtable->tag->fieldList['actions']['type']  = 'actions';
$config->repo->dtable->tag->fieldList['actions']['width'] = 60;
$config->repo->dtable->tag->fieldList['actions']['menu']  = array('deleteTag');

$config->repo->dtable->tag->fieldList['actions']['list']['deleteTag']['icon']         = 'trash';
$config->repo->dtable->tag->fieldList['actions']['list']['deleteTag']['hint']         = $lang->repo->deleteTag;
$config->repo->dtable->tag->fieldList['actions']['list']['deleteTag']['url']          = helper::createLink('repo', 'deleteTag', 'repoID={repoID}&tagName={tagName}');
$config->repo->dtable->tag->fieldList['actions']['list']['deleteTag']['data-confirm'] = array('message' => $lang->repo->confirmTagDelete, 'icon' => 'icon-exclamation-sign', 'iconClass' => 'warning-pale rounded-full icon-2x');
$config->repo->dtable->tag->fieldList['actions']['list']['deleteTag']['className']    = 'ajax-submit';

$config->repo->dtable->branch->fieldList['actions']['name']  = 'actions';
$config->repo->dtable->branch->fieldList['actions']['title'] = $lang->actions;
$config->repo->dtable->branch->fieldList['actions']['type']  = 'actions';
$config->repo->dtable->branch->fieldList['actions']['width'] = 60;
$config->repo->dtable->branch->fieldList['actions']['menu']  = array('deleteBranch');

$config->repo->dtable->branch->fieldList['actions']['list']['deleteBranch']['icon']         = 'trash';
$config->repo->dtable->branch->fieldList['actions']['list']['deleteBranch']['hint']         = $lang->repo->deleteBranch;
$config->repo->dtable->branch->fieldList['actions']['list']['deleteBranch']['url']          = helper::createLink('repo', 'deleteBranch', 'repoID={repoID}&branchName={branchName}');
$config->repo->dtable->branch->fieldList['actions']['list']['deleteBranch']['data-confirm'] = array('message' => $lang->repo->confirmBranchDelete, 'icon' => 'icon-exclamation-sign', 'iconClass' => 'warning-pale rounded-full icon-2x');
$config->repo->dtable->branch->fieldList['actions']['list']['deleteBranch']['className']    = 'ajax-submit';

$config->repo->dtable->webhook = new stdclass();
$config->repo->dtable->webhook->fieldList['name']['title'] = $lang->repo->name;
$config->repo->dtable->webhook->fieldList['name']['type']  = 'title';
$config->repo->dtable->webhook->fieldList['name']['width'] = 300;

$config->repo->dtable->webhook->fieldList['status']['title']     = $lang->repo->status;
$config->repo->dtable->webhook->fieldList['status']['type']      = 'status';
$config->repo->dtable->webhook->fieldList['status']['name']      = 'status';
$config->repo->dtable->webhook->fieldList['status']['statusMap'] = $lang->repo->webhook->statusList;
$config->repo->dtable->webhook->fieldList['status']['sortType']  = true;
$config->repo->dtable->webhook->fieldList['status']['order']     = 20;

$config->repo->dtable->webhook->fieldList['url']['title'] = $lang->repo->targetURL;
$config->repo->dtable->webhook->fieldList['url']['type']  = 'text';
$config->repo->dtable->webhook->fieldList['url']['order'] = 30;

$config->repo->dtable->webhook->fieldList['desc']['title'] = $lang->repo->desc;
$config->repo->dtable->webhook->fieldList['desc']['type']  = 'desc';
$config->repo->dtable->webhook->fieldList['desc']['name']  = 'description';
$config->repo->dtable->webhook->fieldList['desc']['order'] = 40;

$config->repo->dtable->webhook->fieldList['latestStatus']['title']     = $lang->repo->latestStatus;
$config->repo->dtable->webhook->fieldList['latestStatus']['type']      = 'status';
$config->repo->dtable->webhook->fieldList['latestStatus']['statusMap'] = $lang->repo->webhook->latestStatusList;
$config->repo->dtable->webhook->fieldList['latestStatus']['flex']      = 0;
$config->repo->dtable->webhook->fieldList['latestStatus']['sortType']  = true;
$config->repo->dtable->webhook->fieldList['latestStatus']['order']     = 50;
$config->repo->dtable->webhook->fieldList['latestStatus']['width']     = 150;

$config->repo->dtable->webhook->fieldList['actions']['name']  = 'actions';
$config->repo->dtable->webhook->fieldList['actions']['title'] = $lang->actions;
$config->repo->dtable->webhook->fieldList['actions']['type']  = 'actions';
$config->repo->dtable->webhook->fieldList['actions']['width'] = 60;
$config->repo->dtable->webhook->fieldList['actions']['menu']  = array('edit', 'enable|disable', 'log', 'delete');

$config->repo->dtable->webhook->fieldList['actions']['list']['edit']['icon'] = 'edit';
$config->repo->dtable->webhook->fieldList['actions']['list']['edit']['hint'] = $lang->repo->edit;
$config->repo->dtable->webhook->fieldList['actions']['list']['edit']['url']  = array('module' => 'repo', 'method' => 'editWebhook', 'params' => 'repoID={repoID}&webhookID={id}');

$config->repo->dtable->webhook->fieldList['actions']['list']['enable']['icon']      = 'start';
$config->repo->dtable->webhook->fieldList['actions']['list']['enable']['hint']      = $lang->repo->enable;
$config->repo->dtable->webhook->fieldList['actions']['list']['enable']['url']       = array('module' => 'repo', 'method' => 'enableWebhook', 'params' => 'repoID={repoID}&webhookID={id}&isEnable=1');
$config->repo->dtable->webhook->fieldList['actions']['list']['enable']['className'] = 'ajax-submit';

$config->repo->dtable->webhook->fieldList['actions']['list']['disable']['icon']      = 'off';
$config->repo->dtable->webhook->fieldList['actions']['list']['disable']['hint']      = $lang->repo->disable;
$config->repo->dtable->webhook->fieldList['actions']['list']['disable']['url']       = array('module' => 'repo', 'method' => 'enableWebhook', 'params' => 'repoID={repoID}&webhookID={id}&isEnable=0');
$config->repo->dtable->webhook->fieldList['actions']['list']['disable']['className'] = 'ajax-submit';

$config->repo->dtable->webhook->fieldList['actions']['list']['delete']['icon']         = 'trash';
$config->repo->dtable->webhook->fieldList['actions']['list']['delete']['hint']         = $lang->repo->deleteWebhook;
$config->repo->dtable->webhook->fieldList['actions']['list']['delete']['url']          = array('module' => 'repo', 'method' => 'deleteWebhook', 'params' => 'repoID={repoID}&webhookID={id}');
$config->repo->dtable->webhook->fieldList['actions']['list']['delete']['data-confirm'] = array('message' => $lang->repo->webhook->confirmWebhookDelete, 'icon' => 'icon-exclamation-sign', 'iconClass' => 'warning-pale rounded-full icon-2x');
$config->repo->dtable->webhook->fieldList['actions']['list']['delete']['className']    = 'ajax-submit';

$config->repo->dtable->webhook->fieldList['actions']['list']['log']['icon'] = 'history';
$config->repo->dtable->webhook->fieldList['actions']['list']['log']['hint'] = $lang->repo->log;
$config->repo->dtable->webhook->fieldList['actions']['list']['log']['url']  = array('module' => 'repo', 'method' => 'logWebhook', 'params' => 'repoID={repoID}&webhookID={id}');

$config->repo->dtable->logWebhook = new stdclass();
$config->repo->dtable->logWebhook->fieldList['createdDate']['title']      = $lang->repo->webhook->requestDate;
$config->repo->dtable->logWebhook->fieldList['createdDate']['type']       = 'datetime';
$config->repo->dtable->logWebhook->fieldList['createdDate']['formatDate'] = 'YYYY-MM-dd hh:mm';

$config->repo->dtable->logWebhook->fieldList['status']['title']     = $lang->repo->status;
$config->repo->dtable->logWebhook->fieldList['status']['type']      = 'status';
$config->repo->dtable->logWebhook->fieldList['status']['name']      = 'result';
$config->repo->dtable->logWebhook->fieldList['status']['statusMap'] = $lang->repo->webhook->logStatusList;
$config->repo->dtable->logWebhook->fieldList['status']['sortType']  = true;
$config->repo->dtable->logWebhook->fieldList['status']['order']     = 20;

$config->repo->dtable->logWebhook->fieldList['triggerType']['title'] = $lang->repo->webhook->triggerType;
$config->repo->dtable->logWebhook->fieldList['triggerType']['type']  = 'type';
$config->repo->dtable->logWebhook->fieldList['triggerType']['map']   = $lang->repo->webhook->customEventList;
$config->repo->dtable->logWebhook->fieldList['triggerType']['width'] = 150;
$config->repo->dtable->logWebhook->fieldList['triggerType']['order'] = 30;

$config->repo->dtable->logWebhook->fieldList['url']['title'] = $lang->repo->webhook->requestURL;
$config->repo->dtable->logWebhook->fieldList['url']['type']  = 'text';
$config->repo->dtable->logWebhook->fieldList['url']['order'] = 40;

$config->repo->dtable->logWebhook->fieldList['actions']['name']  = 'actions';
$config->repo->dtable->logWebhook->fieldList['actions']['title'] = $lang->actions;
$config->repo->dtable->logWebhook->fieldList['actions']['type']  = 'actions';
$config->repo->dtable->logWebhook->fieldList['actions']['width'] = 60;
$config->repo->dtable->logWebhook->fieldList['actions']['menu']  = array('requestData');

$config->repo->dtable->logWebhook->fieldList['actions']['list']['requestData']['icon']        = 'audit';
$config->repo->dtable->logWebhook->fieldList['actions']['list']['requestData']['hint']        = $lang->repo->webhook->requestData;
$config->repo->dtable->logWebhook->fieldList['actions']['list']['requestData']['url']         = array('module' => 'repo', 'method' => 'viewWebhookRequest', 'params' => 'repoID={repoID}&webhookID={webhookID}&executionID={id}');
$config->repo->dtable->logWebhook->fieldList['actions']['list']['requestData']['data-toggle'] = 'modal';
$config->repo->dtable->logWebhook->fieldList['actions']['list']['requestData']['data-size']   = 'lg';

$config->repo->dtable->rule = new stdclass();
$config->repo->dtable->rule->fieldList['name']['title'] = $lang->repo->name;
$config->repo->dtable->rule->fieldList['name']['type']  = 'title';
$config->repo->dtable->rule->fieldList['name']['width'] = 300;

$config->repo->dtable->rule->fieldList['status']['title']     = $lang->repo->status;
$config->repo->dtable->rule->fieldList['status']['type']      = 'status';
$config->repo->dtable->rule->fieldList['status']['name']      = 'status';
$config->repo->dtable->rule->fieldList['status']['statusMap'] = $lang->repo->rule->statusList;
$config->repo->dtable->rule->fieldList['status']['sortType']  = true;
$config->repo->dtable->rule->fieldList['status']['order']     = 20;

$config->repo->dtable->rule->fieldList['pattern']['title'] = $lang->repo->rule->pattern;
$config->repo->dtable->rule->fieldList['pattern']['type']  = 'text';
$config->repo->dtable->rule->fieldList['pattern']['order'] = 30;

$config->repo->dtable->rule->fieldList['ruleCount']['title']    = $lang->repo->rule->ruleCount;
$config->repo->dtable->rule->fieldList['ruleCount']['type']     = 'int';
$config->repo->dtable->rule->fieldList['ruleCount']['sortType'] = true;
$config->repo->dtable->rule->fieldList['ruleCount']['order']    = 40;
$config->repo->dtable->rule->fieldList['ruleCount']['width']    = 100;

$config->repo->dtable->rule->fieldList['desc']['title'] = $lang->repo->desc;
$config->repo->dtable->rule->fieldList['desc']['type']  = 'desc';
$config->repo->dtable->rule->fieldList['desc']['order'] = 50;

$config->repo->dtable->rule->fieldList['actions']['name']  = 'actions';
$config->repo->dtable->rule->fieldList['actions']['title'] = $lang->actions;
$config->repo->dtable->rule->fieldList['actions']['type']  = 'actions';
$config->repo->dtable->rule->fieldList['actions']['width'] = 60;
$config->repo->dtable->rule->fieldList['actions']['menu']  = array('edit', 'enable|disable', 'delete');

$config->repo->dtable->rule->fieldList['actions']['list']['edit']['icon'] = 'edit';
$config->repo->dtable->rule->fieldList['actions']['list']['edit']['hint'] = $lang->repo->editRule;
$config->repo->dtable->rule->fieldList['actions']['list']['edit']['url']  = array('module' => 'repo', 'method' => 'editRule', 'params' => 'repoID={repoID}&ruleID={id}');

$config->repo->dtable->rule->fieldList['actions']['list']['enable']['icon']      = 'start';
$config->repo->dtable->rule->fieldList['actions']['list']['enable']['hint']      = $lang->repo->enabledRule;
$config->repo->dtable->rule->fieldList['actions']['list']['enable']['url']       = array('module' => 'repo', 'method' => 'enableRule', 'params' => 'repoID={repoID}&ruleID={id}&isEnable=1');
$config->repo->dtable->rule->fieldList['actions']['list']['enable']['className'] = 'ajax-submit';

$config->repo->dtable->rule->fieldList['actions']['list']['disable']['icon']      = 'off';
$config->repo->dtable->rule->fieldList['actions']['list']['disable']['hint']      = $lang->repo->disabledRule;
$config->repo->dtable->rule->fieldList['actions']['list']['disable']['url']       = array('module' => 'repo', 'method' => 'enableRule', 'params' => 'repoID={repoID}&ruleID={id}&isEnable=0');
$config->repo->dtable->rule->fieldList['actions']['list']['disable']['className'] = 'ajax-submit';

$config->repo->dtable->rule->fieldList['actions']['list']['delete']['icon']         = 'trash';
$config->repo->dtable->rule->fieldList['actions']['list']['delete']['hint']         = $lang->repo->deleteRule;
$config->repo->dtable->rule->fieldList['actions']['list']['delete']['url']          = array('module' => 'repo', 'method' => 'deleteRule', 'params' => 'repoID={repoID}&ruleID={id}');
$config->repo->dtable->rule->fieldList['actions']['list']['delete']['data-confirm'] = array('message' => $lang->repo->rule->confirmRuleDelete, 'icon' => 'icon-exclamation-sign', 'iconClass' => 'warning-pale rounded-full icon-2x');
$config->repo->dtable->rule->fieldList['actions']['list']['delete']['className']    = 'ajax-submit';

global $app;
$app->loadLang('deploy');
$app->loadLang('system');
$config->repo->dtable->system = new stdclass();
$config->repo->dtable->system->fieldList['id']['title']    = $lang->idAB;
$config->repo->dtable->system->fieldList['id']['name']     = 'id';
$config->repo->dtable->system->fieldList['id']['type']     = 'id';
$config->repo->dtable->system->fieldList['id']['sortType'] = true;
$config->repo->dtable->system->fieldList['id']['order']    = 5;

$config->repo->dtable->system->fieldList['product']['title']    = $lang->repo->system->product;
$config->repo->dtable->system->fieldList['product']['type']     = 'text';
$config->repo->dtable->system->fieldList['product']['sortType'] = true;
$config->repo->dtable->system->fieldList['product']['order']    = 10;
$config->repo->dtable->system->fieldList['product']['width']    = 0.15;

$config->repo->dtable->system->fieldList['name']['title'] = $lang->repo->system->name;
$config->repo->dtable->system->fieldList['name']['type']  = 'text';
$config->repo->dtable->system->fieldList['name']['hint']  = true;
$config->repo->dtable->system->fieldList['name']['sortType'] = true;
$config->repo->dtable->system->fieldList['name']['order'] = 15;
$config->repo->dtable->system->fieldList['name']['width'] = 0.15;

$config->repo->dtable->system->fieldList['status']['title']     = $lang->repo->system->status;
$config->repo->dtable->system->fieldList['status']['type']      = 'status';
$config->repo->dtable->system->fieldList['status']['name']      = 'status';
$config->repo->dtable->system->fieldList['status']['statusMap'] = $lang->system->statusList;
$config->repo->dtable->system->fieldList['status']['sortType']  = true;
$config->repo->dtable->system->fieldList['status']['align']     = 'left';
$config->repo->dtable->system->fieldList['status']['order']     = 20;
$config->repo->dtable->system->fieldList['status']['width']     = 0.15;

$config->repo->dtable->system->fieldList['latestRelease']['title'] = $lang->repo->system->latestRelease;
$config->repo->dtable->system->fieldList['latestRelease']['name']  = 'latestRelease';
$config->repo->dtable->system->fieldList['latestRelease']['type']  = 'text';
$config->repo->dtable->system->fieldList['latestRelease']['order'] = 25;
$config->repo->dtable->system->fieldList['latestRelease']['width'] = 0.15;

$config->repo->dtable->system->fieldList['deployStatus']['title']     = $lang->repo->system->deployStatus;
$config->repo->dtable->system->fieldList['deployStatus']['type']      = 'status';
$config->repo->dtable->system->fieldList['deployStatus']['name']      = 'deployStatus';
$config->repo->dtable->system->fieldList['deployStatus']['statusMap'] = $lang->deploy->statusList;
$config->repo->dtable->system->fieldList['deployStatus']['align']     = 'left';
$config->repo->dtable->system->fieldList['deployStatus']['width']     = 0.15;
$config->repo->dtable->system->fieldList['deployStatus']['order']     = 30;

/* Search config. */
$config->repo->system = new stdClass();
$config->repo->system->search['module']                 = 'systemSearch';
$config->repo->system->search['fields']['id']           = $lang->idAB;
$config->repo->system->search['fields']['name']         = $lang->repo->system->name;
$config->repo->system->search['fields']['product']      = $lang->repo->system->product;
$config->repo->system->search['fields']['status']       = $lang->repo->system->status;
$config->repo->system->search['fields']['deployStatus'] = $lang->repo->system->deployStatus;

$config->repo->system->search['params']['id']            = array('operator' => '=',       'control' => 'input',  'values' => '');
$config->repo->system->search['params']['name']          = array('operator' => 'include', 'control' => 'input',  'values' => '');
$config->repo->system->search['params']['product']       = array('operator' => '=',       'control' => 'select', 'values' => array());
$config->repo->system->search['params']['status']        = array('operator' => '=',       'control' => 'select', 'values' => $lang->system->statusList);
$config->repo->system->search['params']['deployStatus']  = array('operator' => '=',       'control' => 'select', 'values' => $lang->deploy->statusList);

global $app;
$app->loadLang('codescan');
foreach($config->repo->dtable->fieldList['actions']['menu'] as &$menu)
{
    if($menu == 'execJob')    $menu = 'scanExec|execJob';
    if($menu == 'reportView') $menu = 'scanIssue|reportView';
}
$config->repo->dtable->fieldList['actions']['list']['scanExec']['icon']        = 'start';
$config->repo->dtable->fieldList['actions']['list']['scanExec']['hint']        = $lang->codescan->exec;
$config->repo->dtable->fieldList['actions']['list']['scanExec']['url']         = array('module' => 'codescan', 'method' => 'exec', 'params' => 'planID=0&repoID={id}');
$config->repo->dtable->fieldList['actions']['list']['scanExec']['showText']    = true;
$config->repo->dtable->fieldList['actions']['list']['scanExec']['data-toggle'] = 'modal';

$config->repo->dtable->fieldList['actions']['list']['scanIssue']['icon']        = 'bug';
$config->repo->dtable->fieldList['actions']['list']['scanIssue']['hint']        = $lang->codescan->issue;
$config->repo->dtable->fieldList['actions']['list']['scanIssue']['url']         = array('module' => 'codescan', 'method' => 'issue', 'params' => 'repoID={id}');
$config->repo->dtable->fieldList['actions']['list']['scanIssue']['showText']    = true;
