<?php
namespace zin;

global $app, $config, $lang;
$app->loadLang('artifactrepo');

jsVar('type', data('type'));
jsVar('copyMessage', $lang->artifactrepo->copied);
$releaseModule = $app->rawModule == 'projectrelease' ? 'projectrelease' : 'release';
$release       = data('release');

if(common::hasPriv('release', 'view')) $config->release->artifact->dtable->fieldList['actions']['menu'][] = 'download|copy';
if(empty($release->releases) && common::hasPriv('release', 'edit')) $config->release->artifact->dtable->fieldList['actions']['menu'][] = 'unlinkArtifact';

$buildList = array();
if(!empty(data('artifactBuilds')))
{
    foreach(data('artifactBuilds') as $build)
    {
        $buildList[$build->id] = $build->name;
    }
}

$config->release->artifact->dtable->fieldList['build']['map'] = $buildList;
$data = empty(data('artifactList')) ? array() : initTableData(data('artifactList'), $config->release->artifact->dtable->fieldList);

query('#releaseTabs')->append
(
    tabPane
    (
        to::prefix(icon('stack')),
        set::key('artifacts'),
        set::title($lang->artifactrepo->artifact),
        set::active(data('type') == 'artifacts'),
        dtable
        (
            set::style(array('min-width' => '100%')),
            set::userMap(data('users')),
            set::cols($config->release->artifact->dtable->fieldList),
            set::data($data),
            set::sortLink(createLink($releaseModule, 'view', "releaseID={$release->id}&type=artifacts&link=false&param=&orderBy={name}_{sortType}")),
            set::rowKey('rowKey'),
        )
    ),
    h::css
    (
    <<<CSS
      #releaseTabs .nav-tabs .nav-item[data-key="artifacts"] {order: 4}
      #releaseTabs .nav-tabs .nav-item[data-key="releaseInfo"] {order: 5}
CSS
    )
);
