<?php
/**
 * The control file of publishtemplate module of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2024 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Xiquan Zhang<zhangxiquan@chandao.com>
 * @link        https://www.zentao.net
 */
namespace zin;

/**
 * 创建输入组
 * Generate InputGroup
 *
 * @param string     $type
 * @param array      $fields
 * @param array|null $data
 * @param string     $trashClass
 * @return mixed
 */
$generateInputGroup = function(string $type, array $fields, array $data = null, string $trashClass = '')
{
    global $lang;
    $fieldIndex = $data ? key($data) : 0;
    $fieldValue = $data ? current($data) : null;
    $hideLabel  = 'hidden';// force hidden field title.  if need title, set $hideLabel = $fieldIndex > 0 ? 'hidden' : '';
    $fieldsDiv  = [];
    $needShort  = ['port', 'protocol', 'service'];

    foreach($fields as $index => $field)
    {
        $marginClass = $index == 0 ? '' : 'ml-2';
        $shortClass = in_array($field['name'], $needShort) ? "w-24 $marginClass" : "flex-1 $marginClass";
        $fieldsDiv[] = div
        (
            setClass($shortClass),
            span
            (
                setClass("sub-label flex h-6 {$marginClass} {$hideLabel}"),
                $lang->publishtemplate->{$field['label']}
            ),
            $field['type'] == 'picker' ?
                picker
                (
                    setClass('sub-input mt-2'),
                    set::name("settings[$type][$fieldIndex][{$field['name']}]"),
                    set::items($lang->publishtemplate->{$field['items']}),
                    set::value($fieldValue ? $fieldValue[$field['name']] : ''),
                    zget($field, 'name', '') == 'service' ? null : set::required(true)
                ) :
                input
                (
                    setClass('sub-input mt-2'),
                    set::placeholder($lang->publishtemplate->{$field['label']}),
                    set::name("settings[$type][$fieldIndex][{$field['name']}]"),
                    set::value($fieldValue ? $fieldValue[$field['name']] : ''),
                    set::required(true)
                )
        );
    }

    $fieldsDiv[] = div
    (
        setClass("w-24"),
        span(setClass("sub-label flex h-6 ml-4 {$hideLabel}"), ''),
        span
        (
            setClass("sub-input mt-2 flex ml-4 justify-end"),
            a(setClass("btn btn-link add-$type"), icon('plus'), set::href('javascript:void(0)')),
            a(setClass("btn btn-link del-$type $trashClass"), icon('trash'), set::href('javascript:void(0)'))
        )
    );

    return div(setClass("{$type} flex w-full form-group"), setStyle('padding-left', '0'), ...$fieldsDiv);
};
$inputConfig = array(
    'ports' => array(
        array('name' => 'protocol', 'label' => 'protocol', 'type' => 'picker', 'items' => 'protocolList'),
        array('name' => 'port', 'label' => 'port', 'type' => 'input'),
        array('name' => 'desc', 'label' => 'portDesc', 'type' => 'input')
    ),
    'dirs' => array(
        array('name' => 'dir', 'label' => 'dir', 'type' => 'input'),
        array('name' => 'desc', 'label' => 'dirDesc', 'type' => 'input')
    ),
    'envs' => array(
        array('name' => 'key', 'label' => 'envKey', 'type' => 'input'),
        array('name' => 'value', 'label' => 'envVlue', 'type' => 'input')
    ),
    'services' => array(
        array('name' => 'service', 'label' => 'service', 'type' => 'picker', 'items' => 'serviceList'),
        array('name' => 'desc', 'label' => 'serviceDesc', 'type' => 'input')
    )
);

foreach($inputConfig as $type => $fields)
{
    ${$type . 'Input'} = [];
    if(isset($publishtemplate->settings))
    {
        $isEdit     = true;
        $settings   = json_decode($publishtemplate->settings, true);
        $trashClass = count($settings[$type]) > 1 ? '' : 'invisible';
        if(empty($settings['services'])) $settings['services'] = array(array('service' => '', 'desc' => ''));
        foreach($settings[$type] as $fieldIndex => $fieldValue)
        {
            ${$type . 'Input'}[$fieldIndex] = $generateInputGroup($type, $fields, [$fieldIndex => $fieldValue], $trashClass);
        }
    }
    else
    {
        ${$type . 'Input'}[0] = $generateInputGroup($type, $fields, null, 'invisible');
    }
}

modalHeader(set::title($title), set::titleClass('text-lg font-bold'));
formPanel
(
    set::id('publishtemplateCreateForm'),
    set::submitBtnText($lang->save),
    set::actions(array('submit')),
    formGroup
    (
        set::name('system'),
        set::required(true),
        set::disabled(isset($isEdit)),
        set::label($lang->publishtemplate->system),
        set::labelWidth(common::checkNotCN() ? '160px' : '100px'),
        set::items($lang->publishtemplate->systemList),
        set::value($type),
        on::change()->call('getEnvBySystem'),
        on::change()->call('getHostBySystem'),
        on::change()->call('switchModal')
    ),
    formGroup
    (
        set::name('name'),
        set::required(true),
        set::label($lang->publishtemplate->name),
        set::value(isset($publishtemplate->name) ? $publishtemplate->name : ''),
        set::labelWidth(common::checkNotCN() ? '160px' : '100px')
    ),
    formGroup
    (
        setClass(isset($isEdit) ? "hidden" : ""),
        set::name('productID'),
        set::label($lang->publishtemplate->productName),
        set::labelWidth(common::checkNotCN() ? '160px' : '100px'),
        set::required(true),
        set::items($products),
        on::change()->call('getSystemList')
    ),
    formGroup
    (
        setClass(!isset($isEdit) ? "hidden" : ""),
        set::disabled(isset($isEdit)),
        set::name('productName'),
        set::label($lang->publishtemplate->productName),
        set::labelWidth(common::checkNotCN() ? '160px' : '100px')
    ),
    formGroup
    (
        set::name('systemID'),
        set::disabled(isset($isEdit)),
        set::label($lang->publishtemplate->systemID),
        set::labelWidth(common::checkNotCN() ? '160px' : '100px'),
        set::required(true),
        set::items(isset($isEdit) ? $appList : array()),
        set::value(isset($publishtemplate->systemID) ? $publishtemplate->systemID : 0),
        on::inited()->call('getSystemApp'),
        on::change()->call('getSystemApp'),
        (!isset($isEdit) ? on::inited()->call('getSystemList') : '')
    ),
    formGroup
    (
        set::name('appKey'),
        set::disabled(isset($isEdit)),
        set::required(true),
        set::label($lang->publishtemplate->appKey),
        set::placeholder($lang->publishtemplate->appKeyPlaceholder),
        set::labelWidth(common::checkNotCN() ? '160px' : '100px')
    ),
    formGroup
    (
        set::name('envID'),
        set::hidden(true),
        set::label($lang->publishtemplate->envID),
        set::labelWidth(common::checkNotCN() ? '160px' : '100px'),
        set::items(array()),
//            on::inited()->call('getEnvBySystem'),
//            on::change()->call('getClusterByEnv')
    ),
    formGroup
    (
        set::name('clusterID'),
        set::hidden(true),
        set::label($lang->publishtemplate->clusterID),
        set::labelWidth(common::checkNotCN() ? '160px' : '100px'),
        set::control('picker'),
        set::items(array()),
    ),
    formGroup
    (
        set::id('ports'),
        set::label($lang->publishtemplate->ports),
        set::labelWidth(common::checkNotCN() ? '160px' : '100px'),
        set::labelClass('mt-2'),
        $portsInput,
        set::required(true),
        on::click('.add-ports', 'window.addPorts'),
        on::click('.del-ports', 'window.delPorts'),
    ),
    formGroup
    (
        set::id('dirs'),
        set::label($lang->publishtemplate->dirs),
        set::labelWidth(common::checkNotCN() ? '160px' : '100px'),
        set::labelClass('mt-2'),
        $dirsInput,
        set::required(true),
        on::click('.add-dirs', 'window.addDirs'),
        on::click('.del-dirs', 'window.delDirs'),
    ),
    formGroup
    (
        set::id('envs'),
        set::label($lang->publishtemplate->envs),
        set::labelWidth(common::checkNotCN() ? '160px' : '100px'),
        set::labelClass('mt-2'),
        $envsInput,
        set::required(true),
        on::click('.add-envs', 'window.addEnvs'),
        on::click('.del-envs', 'window.delEnvs'),
    ),
    formGroup
    (
        set::id('services'),
        set::label($lang->publishtemplate->services),
        set::labelWidth(common::checkNotCN() ? '160px' : '100px'),
        set::labelClass('mt-2'),
        $servicesInput,
        on::click('.add-services', 'window.addServices'),
        on::click('.del-services', 'window.delServices'),
    )
);
