$(function()
{
    if(typeof monitorTimer !== 'undefined') clearInterval(monitorTimer);
    if(inQuickon) monitorTimer = setInterval(refreshAppAlerts, 60000);
});

function refreshAppAlerts()
{
    $.ajaxSubmit({
        url: $.createLink('instance', 'ajaxAppAlerts'),
        method: 'POST',
        data: {instanceID: instanceID},
        onComplete: function(res)
        {
            $("#instanceID-" + instanceID).attr('title', '').attr('class', '').html('');
            if(res.result === 'success')
            {
                $.each(res.data, function(index, alert)
                {
                    let id   = "instanceID-" + index;
                    if(alert.warning && alert.warning.tips)
                    {
                        $("#" + id).attr('title', alert.warning.tips).attr('class','ml-3').html('<i class="icon icon-exclamation rounded-full warning-pale"></i>');
                    }
                    if(alert.danger && alert.danger.tips)
                    {
                        $("#" + id).attr('title', alert.danger.tips).attr('class','ml-3').html('<i class="icon icon-exclamation rounded-full danger-pale"></i>');
                    }
                });
            }
        }
    });
}
