<?php
/**
 * The browse view file of env module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yang Li <liyang@chandao.com>
 * @package     env
 * @link        https://www.zentao.net
 */
namespace zin;
jsVar('envLang', $lang->env);

$canCreate  = hasPriv('env', 'create');
$createLink = $this->createLink('env', 'create');
$createItem = array('text' => $lang->env->create, 'url' => $createLink, 'class' => 'primary', 'icon' => 'plus', 'data-toggle' => 'modal');

$tableData = initTableData($envList, $config->env->dtable->fieldList, $this->env);

featureBar();

toolbar
(
    $canCreate ? item(set($createItem)) : null,
);

dtable
(
    set::cols($config->env->dtable->fieldList),
    set::data($tableData),
    set::sortLink(createLink('env', 'browse', "orderBy={name}_{sortType}&recTotal={$pager->recTotal}&recPerPage={$pager->recPerPage}")),
    set::orderBy($orderBy),
    set::actionItemCreator(jsRaw('window.renderActions')),
    set::footPager(usePager())
);
