<?php
/**
 * The artifact view file of deploy module of ZenTaoPMS.
 * @copyright   Copyright 2009-2024 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yanyi Cao <caoyanyi@chandao.com>
 * @package     deploy
 * @link        https://www.zentao.net
 */
namespace zin;

include "{$app->basePath}extension" . DS . $config->edition . DS . "deploy" . DS . "ui" . DS . "nav.html.php";
unset($config->release->artifact->dtable->fieldList['build']);

foreach($artifactList as $key => $artifact)
{
    if($deploy->type == 'cne' && $artifact->name != $deploy->artifact) unset($artifactList[$key]);
    if($deploy->type == 'spug' && ($artifactInfo->format == 'docker' || $artifact->format == 'container')) unset($artifactList[$key]);
}

if(common::hasPriv('release', 'view')) $config->release->artifact->dtable->fieldList['actions']['menu'][] = 'download|copy';
$data = initTableData($artifactList, $config->release->artifact->dtable->fieldList, $this->release);
foreach($config->release->artifact->dtable->fieldList as &$field) $field['sortType'] = false;

$app->loadLang('artifactrepo');
jsVar('copyMessage', $lang->artifactrepo->copied);

panel
(
    div
    (
        set::id('deployMenu'),
        setClass('flex justify-between mb-2'),
        $headers
    ),
    dtable
    (
        set::style(array('min-width' => '100%')),
        set::userMap(data('users')),
        set::cols($config->release->artifact->dtable->fieldList),
        set::data($data),
        set::rowKey('rowKey'),
    )
);
