<?php
/**
 * The create view file of cluster module of ZenTaoPMS.
 * @copyright   Copyright 2009-2024 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yanyi Cao <caoyanyi@chandao.com>
 * @package     cluster
 * @link        https://www.zentao.net
 */
namespace zin;

formPanel
(
    set::id('clusterCreateForm'),
    set::title($lang->cluster->create),
    set::submitBtnText($lang->save),
    formGroup
    (
        set::name('name'),
        set::width(common::checkNotCN() ? '3/4' : '1/2'),
        set::required(true),
        set::label($lang->cluster->name),
    ),
    formGroup
    (
        set::name('apiUrl'),
        set::width(common::checkNotCN() ? '3/4' : '1/2'),
        set::label($lang->cluster->apiUrl),
        set::required(true)
    ),
    formGroup
    (
        set::name('token'),
        set::width(common::checkNotCN() ? '3/4' : '1/2'),
        set::label($lang->cluster->token),
        set::required(true)
    ),
    formGroup
    (
        set::name('env'),
        set::width(common::checkNotCN() ? '3/4' : '1/2'),
        set::required(true),
        set::label($lang->cluster->env),
        set::items($envList)
    ),
    formGroup
    (
        set::name('desc'),
        set::label($lang->cluster->desc),
        set::control(array('type' => 'textarea', 'rows' => '4'))
    )
);
