<?php
/**
 * The browse view file of cluster module of ZenTaoPMS.
 * @copyright   Copyright 2009-2024 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yanyi Cao <caoyanyi@chandao.com>
 * @package     cluster
 * @link        https://www.zentao.net
 */
namespace zin;

$config->cluster->dtable->fieldList['env']['map'] = $envList;
$tableData = initTableData($clusterList, $config->cluster->dtable->fieldList, $this->cluster);

featureBar();

toolbar
(
    hasPriv('cluster', 'create') ? item(set(array(
        'text'        => $lang->cluster->create,
        'url'         => inLink('create'),
        'icon'        => 'plus',
        'data-toggle' => 'modal',
        'class'       => 'primary'
    ))) : null,
);

dtable
(
    set::cols($config->cluster->dtable->fieldList),
    set::data($tableData),
    set::sortLink(createLink('cluster', 'browse', "orderBy={name}_{sortType}&recTotal={$pager->recTotal}&recPerPage={$pager->recPerPage}")),
    set::orderBy($orderBy),
    set::footPager(usePager())
);
