<?php
namespace zin;

global $app, $lang;
$app->loadLang('artifactrepo');
jsVar('repos', data('repos'));
jsVar('buildLang', $lang->build->artifactRepo);

$artifacts = array();
if(!empty(data('artifacts')))
{
    foreach(data('artifacts') as $artifactRepoID => $artifact)
    {
        foreach($artifact as $id => $linkArtifact)
        {
            $artifacts[] = h::tr
            (
                set::className('cursor-pointer artifact-link-list artifact-' . $id),
                h::td
                (
                    icon('stack mr-1'),
                    $linkArtifact['name'],
                    set::title($linkArtifact['name']),
                    input(set::type('hidden'), set::name("artifacts[$artifactRepoID][$id][name]"), set::value($linkArtifact['name']), set::className('text-left artifact-i' . $id)),
                    input(set::type('hidden'), set::name("artifacts[$artifactRepoID][$id][path]"), set::value($linkArtifact['path']), set::className('text-left artifact-path')),
                    input(set::type('hidden'), set::name("artifacts[$artifactRepoID][$id][type]"), set::value($linkArtifact['type']), set::className('text-left artifact-type-' . $id)),
                    button
                    (
                        setClass('ml-2 unlink-action text-primary ajax-submit ghost unlink-btn hidden'),
                        icon('unlink', set::title($lang->build->artifactRepo->unlinkArtifact))
                    )
                )
            );
        }
    }
}

empty(data('build')->files) ? query('#buildDate')->after
(
    btn
    (
        set::className('btn primary-Outline artifactrepo hidden ml-2'),
        $lang->build->artifactRepo->selectArtifact,
        on::click()->call('window.selectArtifact')
    )
) : null;

query('#buildDateRow')->after
(
    formRow
    (
        set::id('artifactList'),
        formGroup
        (
            set::label($lang->artifactrepo->artifact),
            set::width('1/2'),
            on::mouseenter('.artifact-link-list')->call('window.mouseEvent', 'enter', jsRaw('this')),
            on::mouseleave('.artifact-link-list')->call('window.mouseEvent', 'leave', jsRaw('this')),
            on::click('#artifactList .unlink-btn')->call('window.unlinkArtifact', jsRaw('this')),
            h::table
            (
                setClass('table table-hover table-fixed condensed borderless'),
                empty($artifacts) ? h::tbody() : $artifacts
            )
        )
    )
);
