<?php
if($config->inQuickon)
{
    $config->bi->builtin->metrics[] = array
    (
        'name'       => '按系统统计的活跃代码库数',
        'alias'      => '系统代码活跃代码库数',
        'code'       => 'count_of_active_repo',
        'purpose'    => 'scale',
        'scope'      => 'system',
        'object'     => 'code',
        'unit'       => 'count',
        'dateType'   => 'nodate',
        'desc'       => '活跃代码库数是衡量开发团队在一定时间内参与项目开发和维护的重要指标。通过统计在特定时间范围内有代码提交的代码库数量，团队能够有效评估其开发生态的活跃度和资源分配情况。',
        'definition' => "在所选时间内有代码提交的代码库数量\n不统计已删除代码库。"
    );

    $config->bi->builtin->metrics[] = array
    (
        'name'       => '按系统统计的代码提交次数',
        'alias'      => '系统代码提交次数',
        'code'       => 'count_of_code_commits_in_repo',
        'purpose'    => 'scale',
        'scope'      => 'system',
        'object'     => 'code',
        'unit'       => 'times',
        'dateType'   => 'nodate',
        'desc'       => '按系统统计的代码提交次数所有代码库提交次数之和，是衡量开发团队工作活跃度和迭代频率的重要指标。通过统计一定时间范围内的代码提交数量，团队能够有效评估开发进展，识别工作模式，并促进持续改进。',
        'definition' => "所有代码库提交次数之和\n不统计已删除代码库\n不统计已删除提交"
    );

    $config->bi->builtin->metrics[] = array
    (
        'name'       => '按系统统计的代码提交人数',
        'alias'      => '系统代码提交人数',
        'code'       => 'count_of_user_code_commits_in_repo',
        'purpose'    => 'scale',
        'scope'      => 'system',
        'object'     => 'code',
        'unit'       => 'people',
        'dateType'   => 'nodate',
        'desc'       => '按系统统计的代码提交人数所有代码库提交过的用户之和，通过统计一定时间范围内进行代码提交的独立开发人员数量，团队能够有效评估整体开发活跃度和团队协作情况。',
        'definition' => "所有代码库提交过的人数"
    );

    $config->bi->builtin->metrics[] = array
    (
        'name'       => '按代码库统计的每日代码提交次数',
        'alias'      => '代码库每日提交次数',
        'code'       => 'count_of_daily_code_commits_in_codebase',
        'purpose'    => 'rate',
        'scope'      => 'repo',
        'object'     => 'commit',
        'unit'       => 'times',
        'dateType'   => 'day',
        'desc'       => '按代码库统计的的每日代码提交次数是指代码库每日的代码提交数量。这个度量项可以反映代码库每日开发活动频率和代码更新情况。',
        'definition' => "代码库中代码提交次数求和，提交时间为某日。"
    );

    $config->bi->builtin->metrics[] = array
    (
        'name'       => '按代码库统计的日代码新增行数',
        'alias'      => '代码库日新增行数',
        'code'       => 'count_of_daily_add_rows_in_codebase',
        'purpose'    => 'rate',
        'scope'      => 'repo',
        'object'     => 'commit',
        'unit'       => 'row',
        'dateType'   => 'day',
        'desc'       => '按代码库统计的的日代码新增行数是指代码库在某日的代码提交新增的代码行数量。这个度量项可以反映代码库单日开发活动频率和代码更新情况。',
        'definition' => "代码库中代码提交新增行数求和，提交时间为某日。"
    );

    $config->bi->builtin->metrics[] = array
    (
        'name'       => '按代码库统计的日代码删除行数',
        'alias'      => '代码库日删除行数',
        'code'       => 'count_of_daily_delete_rows_in_codebase',
        'purpose'    => 'rate',
        'scope'      => 'repo',
        'object'     => 'commit',
        'unit'       => 'row',
        'dateType'   => 'day',
        'desc'       => '按代码库统计的的日代码删除行数是指代码库在某日的代码提交删除的代码行数量。这个度量项可以反映代码库单日开发活动频率和代码更新情况。',
        'definition' => "代码库中代码提交删除行数求和，提交时间为某日。"
    );

    $config->bi->builtin->metrics[] = array
    (
        'name'       => '按人员统计的每日代码提交次数',
        'alias'      => '人员日提交次数',
        'code'       => 'count_of_daily_code_commits_in_user',
        'purpose'    => 'rate',
        'scope'      => 'user',
        'object'     => 'commit',
        'unit'       => 'times',
        'dateType'   => 'day',
        'desc'       => '按提交人统计的每日代码提交次数是指单个提交人每日的全部代码提交操作的量。代码提交次数反映了提交人每日的开发活动频率和代码更新情况。',
        'definition' => "所有代码提交次数求和 提交人为某人 提交时间为某日。"
    );

    $config->bi->builtin->metrics[] = array
    (
        'name'       => '按人员统计的日代码新增行数',
        'alias'      => '人员日新增行数',
        'code'       => 'count_of_daily_add_rows_in_user',
        'purpose'    => 'rate',
        'scope'      => 'user',
        'object'     => 'commit',
        'unit'       => 'row',
        'dateType'   => 'day',
        'desc'       => '按提交人统计的日代码新增行数是指单个提交人每日的全部代码提交操作的代码新增行数量。代码提交次数反映了提交人每日的开发活动频率和代码更新情况。',
        'definition' => "所有代码新增行数求和 提交人为某人 提交时间为某日。"
    );

    $config->bi->builtin->metrics[] = array
    (
        'name'       => '按人员统计的日代码删除行数',
        'alias'      => '人员日新删除数',
        'code'       => 'count_of_daily_delete_rows_in_user',
        'purpose'    => 'rate',
        'scope'      => 'user',
        'object'     => 'commit',
        'unit'       => 'row',
        'dateType'   => 'day',
        'desc'       => '按提交人统计的日代码删除行数是指单个提交人每日的全部代码提交操作的代码新删除数量。代码提交次数反映了提交人每日的开发活动频率和代码更新情况。',
        'definition' => "所有代码提交删除行数求和 提交人为某人 提交时间为某日。"
    );

    $config->bi->builtin->metrics[] = array
    (
        'name'       => '按系统统计的每日代码提交次数',
        'alias'      => '系统代码每日提交次数',
        'code'       => 'count_of_daily_code_commits',
        'purpose'    => 'rate',
        'scope'      => 'system',
        'object'     => 'commit',
        'unit'       => 'times',
        'dateType'   => 'day',
        'desc'       => '按系统统计的每日代码提交次数是指本系统每日的全部代码提交的数量，这个度量项可以反映组织的每日开发活动频率和代码更新情况。',
        'definition' => "所有代码库的代码提交次数求和，提交时间为某日。"
    );

    $config->bi->builtin->metrics[] = array
    (
        'name'       => '按系统统计环境总数',
        'alias'      => '环境总数',
        'code'       => 'count_of_env',
        'purpose'    => 'scale',
        'scope'      => 'system',
        'object'     => 'env',
        'unit'       => 'count',
        'dateType'   => 'nodate',
        'desc'       => '按系统统计的环境总数是指在禅道中的全部环境总数。',
        'definition' => "所有环境的个数求和"
    );

    $config->bi->builtin->metrics[] = array
    (
        'name'       => '按系统统计Gitfox制品总数',
        'alias'      => '制品总数',
        'code'       => 'count_of_gitfox_artifact',
        'purpose'    => 'scale',
        'scope'      => 'system',
        'object'     => 'artifact',
        'unit'       => 'count',
        'dateType'   => 'nodate',
        'desc'       => '按系统统计的Gitfox制品总数是指在禅道中GitFox类型制品库的全部制品总数。',
        'definition' => "所有的Gitfox制品求和"
    );

    $config->bi->builtin->metrics[] = array
    (
        'name'       => '按制品库统计Gitfox制品总数',
        'alias'      => '制品库制品数',
        'code'       => 'count_of_gitfox_artifact_in_artifactrepo',
        'purpose'    => 'scale',
        'scope'      => 'artifactrepo',
        'object'     => 'artifact',
        'unit'       => 'count',
        'dateType'   => 'nodate',
        'desc'       => '按制品库统计的Gitfox制品总数是指在禅道中GitFox类型制品库下的制品总数。',
        'definition' => "制品库的Gitfox制品求和"
    );
}
