<?php
/**
 * The view view file of artifactrepo module of ZenTaoPMS.
 * @copyright   Copyright 2009-2024 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yanyi Cao <caoyanyi@easycorp.ltd>
 * @package     artifactrepo
 * @link        https://www.zentao.net
 */
namespace zin;

jsVar('repoID', $repoID);
jsVar('repo', $repo);
jsVar('copiedLang', $lang->artifactrepo->copied);

$repoList = array();
foreach($repoPairs as $id => $repoName) $repoList[] = array('text' => $repoName, 'value' => $id, 'url' => inLink('view', "repoID=$id"));

empty($tree) ? div
(
    setClass('dtable-empty-tip'),
    div
    (
        setClass('text-gray'),
        $lang->noData
    )
) : null;

sidebar
(
    set::side('left'),
    setClass('repo-sidebar canvas'),
    set::width(300),
    set::preserve(false),
    div(
        setClass('flex gap-2 p-2 items-center'),
        span($lang->artifactrepo->common),
        picker
        (
            setClass('flex-1'),
            set::name('repoID'),
            set::items($repoList),
            set::value($repoID),
            set::required(true)
        )
    ),
    count($tree) ? div(
        setClass('p-2'),
        treeEditor
        (
            set::id('filesTree'),
            set::items($tree),
            set::canSplit(false),
            set::collapsedIcon('folder text-warning'),
            set::expandedIcon('folder-open text-warning'),
            set::normalIcon('stack'),
            set::preserve(false),
            set::expanded(false),
            set::onClickItem(jsRaw('window.treeClick'))
        )
    ) : null
);

panel
(
    setClass('file-list hidden'),
    h::table
    (
        setClass('table condensed bordered text-center'),
        h::thead
        (
            h::tr
            (
                h::th
                (
                    $lang->artifactrepo->fileName
                ),
                h::th
                (
                    width('100px'),
                    $lang->artifactrepo->size
                ),
                h::th
                (
                    width('200px'),
                    $lang->artifactrepo->sha
                ),
                h::th
                (
                    width('150px'),
                    $lang->artifactrepo->editedDate
                )
            )
        ),
        h::tbody()
    )
);

panel
(
    setClass('container-list hidden'),
    div
    (
        setClass('flex justify-between mb-4 items-center'),
        div(setClass('artifact-name')),
        inputGroup
        (
            setClass('w-1/2'),
            input
            (
                set::readonly(true),
                setClass('docker-url'),
                set::value('docker pull')
            ),
            span
            (
                on::click()->call('window.copyDocker', jsRaw('$this')),
                setClass('input-group-addon cursor-pointer'),
                icon('copy')
            )
        )
    ),
    h::table
    (
        setClass('table condensed bordered text-center'),
        h::thead
        (
            h::tr
            (
                h::th
                (
                    $lang->artifactrepo->sha
                ),
                h::th
                (
                    width('200px'),
                    $repo->format != 'docker' ? $lang->artifactrepo->arch : $lang->artifactrepo->editedDate
                ),
                h::th
                (
                    width('150px'),
                    $lang->artifactrepo->size
                ),
            )
        ),
        h::tbody()
    )
);
