window.treeClick = function(info)
{
    const {item} = info;
    $('#filesTree .listitem').removeClass('selected');
    $('li[z-key="' + item.id + '"] > .listitem').addClass('selected');
    $('li[z-key="' + item.id + '"] .menu-nested .is-expanded').each(function(){$(this).trigger('click')});
    $('li[z-key="' + item.id + '"] .menu-nested .selected').removeClass('selected');
    $.cookie.set('artifactDir', item.path);

    if(item.leaf && item.format && item.format == 'container') return window.loadFiles(item);
    if(item.items) return;

    if(item.format) item.assetID = item.metadata.node_id;
    $.getJSON($.createLink('artifactrepo', 'ajaxGetAssetInfo', `repoID=${repoID}&assetID=${item.assetID}`), function(asset)
    {
        $('.file-list, .container-list').addClass('hidden');
        if(!asset) return;

        const size = computeSize(asset.size);
        if(asset.format === 'docker')
        {
            const pullUrl = asset.name.replace('\/manifests\/', ':').replace(/v\d\//, '');
            $('.docker-url').val(`docker pull ${pullUrl}`);

            const table = `<tr>
                <td title="${asset.attributes.checksum.sha1}">${asset.attributes.checksum.sha1}</td>
                <td>${asset.editTime}</td>
                <td>${size}</td>
            </tr>`;

            $('.container-list tbody').html(table);
            $('.container-list').removeClass('hidden');
        }
        else
        {
            if(!item.name) item.name = item.path;
            const sha1 = asset.attributes ? asset.attributes.checksum.sha1 : asset.checksum.sha1;
            const table = `<tr>
                <td>
                  <a href="${asset.url}" target="_blank">${item.name}</a>
                </td>
                <td>${size}</td>
                <td>${sha1}</td>
                <td>${asset.editTime}</td>
            </tr>`;

            $('.file-list tbody').html(table);
            $('.file-list').removeClass('hidden');
        }
    });
}

window.computeSize = function(size)
{
    if(size > 1024 * 1024 * 1024)
    {
        return (size / 1024 / 1024 / 1024).toFixed(2) + ' GB';
    }
    else if(size > 1024 * 1024)
    {
        return (size / 1024 / 1024).toFixed(2) + ' MB';
    }
    else if(size > 1024)
    {
        return (size / 1024).toFixed(2) + ' KB';
    }
    else
    {
        return size + ' B';
    }
}

window.loadFiles = function(item)
{
    $.ajaxSubmit(
    {
        url: $.createLink('gitfox', 'ajaxGetArtifacts', `repoID=${item.serverID}`),
        data: {
            project: item.repoName,
            format:  item.format,
            package: item.metadata.name,
            version: item.metadata.version,
            group:   item.metadata.group
        },
        onComplete: (data) =>
        {
            $('.file-list, .container-list').addClass('hidden');

            $('#filesTree .listitem').removeClass('selected');

            $('li[z-key="' + item.id + '"] .listitem').addClass('selected');

            const {type, files, serverUrl} = data;
            if(!type || !serverUrl) return;

            const artifact = `${repo.repoName}/${item.metadata.name}:${item.metadata.version}`;
            const server   = serverUrl.replace(/http(s)?:\/\//, '');
            $('.docker-url').val(`docker pull ${server}/${artifact}`);

            let table = '';
            files.forEach((file) =>
            {
                const size = computeSize(file.size);
                file.digest = file.digest.substr(7);
                table += `<tr>
                    <td title="${file.digest}">${file.digest}</td>
                    <td>${file.os} / ${file.arch}</td>
                    <td>${size}</td>
                </tr>`;
            });
            $('.container-list tbody').html(table);
            $('.container-list').removeClass('hidden');
        }
    });
}

window.copyDocker = function(dom)
{
    $(dom).closest('.input-group').find('.docker-url')[0].select();
    document.execCommand('copy');
    window.getSelection().removeAllRanges();

    zui.Messager.show({
        type:    'success',
        content: copiedLang,
        time:    2000
    });
}
