<?php
/**
 * The Timeaxis widget class file for the zin module of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2024 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      sunhao<sunhao@easycorp.ltd>
 * @package     zin
 * @link        https://www.zentao.net
 */
namespace zin;
/**
 * 时间轴（timeaxis）部件类
 * The timeaxis widget class
 */
class timeaxis extends wg
{
    /**
     * Define widget properties.
     *
     * @var    array
     * @access protected
     */
    protected static $defineProps = array
    (
        'title: string',
        'items?: string'
    );

    public static function getPageCSS()
    {
        return file_get_contents(__DIR__ . DS . 'css' . DS . 'v1.css');
    }

    public static function getPageJS()
    {
        return file_get_contents(__DIR__ . DS . 'js' . DS . 'v1.js');
    }

    /**
     * Build the widget.
     *
     * @access protected
     * @return mixed
     */
    protected function build()
    {
        $title = $this->prop('title');
        $items = $this->prop('items');
        return panel
        (
            setClass('dynamic-block'),
            set::title($title),
            $this->buildBody($items)
        );
    }

    private function buildBody($items)
    {
        $items = $this->buildItems($items);
        return div
        (
            setClass('timeaxis-line'),
            ul(
                $items
            )
        );
    }

    private function buildItems($items)
    {
        $formatItems = [];
        foreach ($items as &$item) $formatItems[] = $this->buildItem($item);

        return $formatItems;
    }

    private function buildItem($item)
    {

        /* 事件信息 Load event info. */
        $eventInfo = $item->eventInfo;
        if(empty($eventInfo)) return null;
        $eventName  = zget($eventInfo, 'name', '');
        $eventColor = zget($eventInfo, 'color', '');
        $eventTime  = zget($eventInfo, 'time', '');
        $linkUrl    = zget($eventInfo, 'linkUrl', '');
        $linkCode   = zget($eventInfo, 'linkCode', '');

        /* 用户信息 Load actor info. */
        $actorInfo =  $item->actorInfo;
        $actor     = !empty($actorInfo->realname) ? $actorInfo->realname : '';
        $avatar    = !empty($actorInfo->avatar) ? $actorInfo->avatar : '';
        if(empty($actor))
        {
            global $app, $lang;
            $app->loadLang('action');
            $actor  = $lang->action->system;
        }
        return li
        (
            span
            (
                setCssVar('timeaxis-border-color', 'var(--color-' . $eventColor . '-500)'),
                setClass('inline-block w-full relative'),
                div(setClass('date text-sm text-gray'), $eventTime),
                div
                (
                    setClass('text-ellipsis'),
                    avatar( set::size(20), set::text($actor), set::src($avatar), set::title($actor)),
                    span(setClass('text-gray ml-1'), $eventName),
                    a(
                        setClass('w-full relative primary-ghost h-10 leading-10 ml-1.5'),
                        $linkUrl ? set::href($linkUrl) : null,
                        $linkCode,
                        set::title($linkCode)
                    )
                )
            )
        );
    }
}

function timeaxis(...$args)
{
    return new timeaxis(...$args);
}
