<?php
/**
 * The sidebar view file of repo module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yang Li<liyang@chandao.com>
 * @package     repo
 * @link        https://www.zentao.net
 */
namespace zin;
dropmenu
(
    set::module('repo'),
    set::tab('repo'),
    set::url(createLink('repo', 'ajaxGetDropMenu', "repoID={$repoID}&module={$app->rawModule}&method={$app->rawMethod}"))
);

$menuItems = array();
foreach($lang->repo->{$ruleType}->rules as $type => $rule)
{
    $currentModule = 'repo';
    $method        = 'set' . ucfirst($type) . 'Rule';
    $params        = "repoID=$repoID";
    $active        = $app->rawMethod == strtolower($method) ? 'active' : '';
    if(!common::hasPriv($currentModule, $method)) continue;

    $menuItems[] = li
    (
        setClass('menu-item'),
        a
        (
            setClass($active),
            set::href(createLink($currentModule, $method, $params)),
            setData(array('load' => '', 'no-morph' => 'false')),
            $rule
        )
    );
}

$menuItems ? sidebar
(
    set::showToggle(false),
    div
    (
        setClass('cell p-2.5 bg-white'),
        menu($menuItems)
    )
) : null;
