<?php
/**
 * The browse webhooks view file of repo module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yang Li <liyang@chandao.com>
 * @package     repo
 * @link        https://www.zentao.net
 */
namespace zin;
$module = $app->tab == 'devops' ? 'repo' : $app->tab;
dropmenu
(
    set::module($module),
    set::tab($module),
    set::url(createLink($module, 'ajaxGetDropMenu', "objectID=0&module={$app->rawModule}&method={$app->rawMethod}"))
);

featureBar(backBtn(set::icon('back'), $lang->goback));

$logList = initTableData($logs, $config->repo->dtable->logWebhook->fieldList);
$urlParams = array(
    'repoID'     => $repo->id,
    'webhookID'  => $webhookID,
    'orderBy'    => '{name}_{sortType}',
    'recPerPage' => $pager->recPerPage,
    'pageID'     => $pager->pageID
);
dtable
(
    set::cols($config->repo->dtable->logWebhook->fieldList),
    set::data($logList),
    set::sortLink(createLink('repo', 'logwebhook', $urlParams)),
    set::orderBy($orderBy),
    set::footPager(usePager())
);
