<?php
namespace zin;
global $app, $lang;
$repo          = data('repo');
$users         = data('users');
$committers    = data('committers');
$defaultBranch = data('defaultBranch');
$branchList    = data('branchList');

$systemGitfox = $app->control->loadModel('instance')->getSystemServer();

if(!empty($repo) && strtolower($repo->SCM) == 'gitfox')
{
    query('#aclList')->before(formGroup
    (
        set::width('1/2'),
        set::name("defaultBranch"),
        set::label($lang->repo->defaultBranch),
        set::control(array('type' => 'picker', 'required' => true)),
        set::items($branchList),
        set::value($defaultBranch)
    ),
    !empty($systemGitfox) && $systemGitfox->id == $repo->serviceHost ? formRow
    (
        setID("committer"),
        formGroup
        (
            set::width('1/2'),
            set::name("committer"),
            set::label($lang->repo->committer),
            set::control('picker'),
            set::multiple(true),
            set::items($users),
            set::value($committers)
        ),
        span
        (
            icon('help'),
            setClass('ml-2 mt-2'),
            toggle::tooltip(array('title' => $lang->repo->committerTip)),
            setData(array(
                'type'       => 'white',
                'placement'  => 'right',
                'class-name' => 'text-gray border border-light'
            ))
        )
    ) : null);
}
