<?php
/**
 * The control file of publishtemplate module of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2024 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Xiquan Zhang<zhangxiquan@chandao.com>
 * @link        https://www.zentao.net
 */
namespace zin;

/**
 * 创建命令表单组
 *
 * @param string $type local|target
 * @param int $key
 * @param array|null $value
 * @return string
 */
$createCommandForm = function(string $type, int $key, array $value = null)
{
    global $lang;
    $isLocal   = $type === 'local';
    $className = "item-{$type} form" . (!$isLocal ? ' mb-3' : '');

    return div
    (
        setClass($className),
        formGroup
        (
            set::name("settings[{$type}Command][{$key}][title]"),
            set::required(true),
            set::label($lang->publishtemplate->{$type . 'Command'}->title),
            set::labelWidth(common::checkNotCN() ? '160px' : '100px'),
            isset($value) ? set::value($value['title']) : null
        ),
        formGroup
        (
            $isLocal ? setClass('mb-3') : null,
            set::name("settings[{$type}Command][{$key}][data]"),
            set::label($lang->publishtemplate->{$type . 'Command'}->data),
            set::required(true),
            set::labelWidth(common::checkNotCN() ? '160px' : '100px'),
            set::control(array('type' => 'textarea', 'rows' => '4')),
            isset($value) ? set::value($value['data']) : null
        )
    );
};
$localCommand  = array();
$targetCommand = array();
$templateID    = empty($publishtemplate->id) ? 0 : $publishtemplate->id;
if(isset($publishtemplate->settings))
{
    $isEdit   = true;
    $settings = json_decode($publishtemplate->settings, true);

    if(empty($settings['localCommand'])) $localCommand[0] = $createCommandForm('local', 0);
    foreach($settings['localCommand'] as $key => $value) $localCommand[$key] = $createCommandForm('local', $key, $value);

    if(empty($settings['targetCommand'])) $targetCommand[0] = $createCommandForm('target', 0);
    foreach($settings['targetCommand'] as $key => $value) $targetCommand[$key] = $createCommandForm('target', $key, $value);
}
else
{
    $localCommand[0]  = $createCommandForm('local', 0);
    $targetCommand[0] = $createCommandForm('target', 0);
}
jsVar('rawMethod', $app->rawMethod);
modalHeader(set::title($title), set::titleClass('text-lg font-bold'));
formPanel
(
    set::id('publishtemplateCreateForm'),
    set::submitBtnText($lang->save),
    on::click('#changeStep')->call('changeStep', $lang->publishtemplate->step->next, $lang->publishtemplate->step->prev, $templateID),
    set::actions(array(
        array(
            'text'  => $lang->publishtemplate->step->next,
            'type'  => 'submit',
            'id'    => 'changeStep',
            'class' => 'btn secondary',
        ),
        array('text' => $lang->save, 'id' => 'save-button', 'class' => 'btn primary hidden', 'btnType' => 'submit')
    )),
    div
    (
        set::id('templateStep-1'),
        setClass('form'),
        formGroup
        (
            set::name('system'),
            set::disabled(isset($isEdit)),
            set::required(true),
            set::label($lang->publishtemplate->system),
            set::labelWidth(common::checkNotCN() ? '160px' : '100px'),
            set::control('picker'),
            set::items($lang->publishtemplate->systemList),
            set::value($type),
            on::change()->call('getEnvBySystem'),
            on::change()->call('getHostBySystem'),
            on::change()->call('switchModal')
        ),
        formGroup
        (
            set::name('name'),
            set::disabled(isset($isEdit)),
            set::required(true),
            set::label($lang->publishtemplate->name),
            set::value(isset($publishtemplate->name) ? $publishtemplate->name : ''),
            set::labelWidth(common::checkNotCN() ? '160px' : '100px')
        ),
        formGroup
        (
            setClass(isset($isEdit) ? "hidden" : ""),
            set::name('productID'),
            set::label($lang->publishtemplate->productName),
            set::labelWidth(common::checkNotCN() ? '160px' : '100px'),
            set::required(true),
            set::items($products),
            set::control('picker'),
            on::change()->call('getSystemList')
        ),
        formGroup
        (
            setClass(!isset($isEdit) ? "hidden" : ""),
            set::disabled(isset($isEdit)),
            set::name('productName'),
            set::label($lang->publishtemplate->productName),
            set::labelWidth(common::checkNotCN() ? '160px' : '100px')
        ),
        formGroup
        (
            set::name('systemID'),
            set::disabled(isset($isEdit)),
            set::label($lang->publishtemplate->systemID),
            set::labelWidth(common::checkNotCN() ? '160px' : '100px'),
            set::required(true),
            set::items(isset($isEdit) ? $appList : array()),
            set::value(isset($publishtemplate->systemID) ? $publishtemplate->systemID : 0),
            set::control('picker'),
            on::inited()->call('getSystemApp'),
            on::change()->call('getSystemApp'),
            (!isset($isEdit) ? on::inited()->call('getSystemList') : '')
        ),
        formGroup(set::name('remoteID'), set::hidden(true), set::value(isset($publishtemplate->remoteID) ? $publishtemplate->remoteID : 0)),
        formGroup
        (
            set::name('appKey'),
            set::disabled(isset($isEdit)),
            set::required(true),
            set::label($lang->publishtemplate->appKey),
            set::placeholder($lang->publishtemplate->appKeyPlaceholder),
            set::labelWidth(common::checkNotCN() ? '160px' : '100px')
        ),
        formGroup
        (
            set::name('envID'),
            set::required(true),
            set::label($lang->publishtemplate->envID),
            set::labelWidth(common::checkNotCN() ? '160px' : '100px'),
            set::control('picker'),
            set::items(array()),
            on::inited()->call('getEnvBySystem', (isset($publishtemplate->envID) ? $publishtemplate->envID : 0))
        ),
        formGroup
        (
            set::name('hosts'),
            set::required(true),
            set::label($lang->publishtemplate->hosts),
            set::labelWidth(common::checkNotCN() ? '160px' : '100px'),
            set::control('picker'),
            set::items(array()),
            set::multiple(true),
            on::inited()->call('getHostBySystem', explode(',', (isset($publishtemplate->hosts) ? $publishtemplate->hosts : '')))
        ),
        formGroup
        (
            set::name('settings[mode]'),
            set::label($lang->publishtemplate->mode),
            set::labelWidth(common::checkNotCN() ? '160px' : '100px'),
            set::control('radioListInline'),
            set::inline(true),
            set::required(true),
            set::value(isset($settings['mode']) ? $settings['mode'] : 1),
            set::items($lang->publishtemplate->modeList)
        ),
        formGroup
        (
            set::name('desc'),
            set::label($lang->publishtemplate->desc),
            set::labelWidth(common::checkNotCN() ? '160px' : '100px'),
            set::value(isset($publishtemplate->desc) ? $publishtemplate->desc : ''),
            set::control(array('type' => 'textarea', 'rows' => '4'))
        )
    ),
    div
    (
        set::id('templateStep-2'),
        setClass('hidden'),
        div(set::id('localBox'), $localCommand),
        formGroup
        (
            div
            (
                set::class('mb-3 flex mr-0 ml-auto'),
                span
                (
                    setClass('input-group-addon'),
                    a(setClass('add-item'), set::href('javascript:void(0)'), icon('plus')),
                    on::click()->call('addItem', 'local')
                ),
                span
                (
                    setClass('input-group-addon'),
                    a(setClass('delete-item'), set::href('javascript:void(0)'), icon('minus')),
                    on::click()->call('removeItem', 'local')
                )
            )
        ),
        div(set::id('targetBox'), $targetCommand),
        formGroup
        (
            div
            (
                set::class('mt-3 flex mr-0 ml-auto'),
                span
                (
                    setClass('input-group-addon'),
                    a(setClass('add-item'), set::href('javascript:void(0)'), icon('plus')),
                    on::click()->call('addItem', 'target')
                ),
                span
                (
                    setClass('input-group-addon'),
                    a(setClass('delete-item'), set::href('javascript:void(0)'), icon('minus')),
                    on::click()->call('removeItem', 'target')
                )
            )
        )
    )
);
