<?php
/**
 * The create pipeline view file of job module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yang Li <liyang@chandao.com>
 * @package     job
 * @link        https://www.zentao.net
 */
namespace zin;

modalHeader
(
    set::title($lang->job->createPipeline),
    set::titleClass('panel-title text-lg')
);

formPanel
(
    formGroup
    (
        setID('pipelineName'),
        set::label($lang->job->pipelineName),
        set::labelWidth(common::checkNotCN() ? '120px' : '100px'),
        set::required(true),
        set::name('pipelineName'),
        on::input('updateYamlPath')
    ),
    formGroup
    (
        set::label($lang->job->repoBranch),
        set::labelWidth(common::checkNotCN() ? '120px' : '100px'),
        set::required(true),
        picker
        (
            set::name('branch'),
            set::items($branchList),
            set::value(key($branchList))
        )
    ),
    formGroup
    (
        setID('yamlPath'),
        set::label($lang->job->yamlPath),
        set::labelWidth(common::checkNotCN() ? '120px' : '100px'),
        set::required(true),
        set::name('yamlPath')
    )
);
