<?php
/**
 * The submit view file of submit module of ZenTaoPMS.
 * @copyright   Copyright 2009-2024 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Mengyi Liu
 * @package     submit
 * @link        https://www.zentao.net
 */
namespace zin;

modalHeader();

form
(
    formGroup
    (
        $deploy->status == 'reverting' ? setClass('hidden') : '',
        set::label($lang->deploy->reviewer),
        div(setID('reviewerBox'))
    ),
    formGroup
    (
        set::label($lang->comment),
        set::name('comment'),
        set::control('editor')
    )
);

history();

jsVar('deployID', $deploy->id);

pageJS(<<<JAVASCRIPT
$(function()
{
    var link = $.createLink('deploy', 'ajaxGetNodes', 'deployID=' + deployID);
    loadCurrentPage({url: link, selector: '#reviewerBox', partial: true});
});
JAVASCRIPT
);
