<?php
/**
 * The setting view file of deploy module of ZenTaoPMS.
 * @copyright   Copyright 2009-2024 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yanyi Cao <caoyanyi@chandao.com>
 * @package     deploy
 * @link        https://www.zentao.net
 */
namespace zin;

formPanel
(
    set::actions(array('submit')),
    set::actionsClass('w-1/2'),
    set::title($lang->deploy->setting),
    set::labelWidth('12em'),
    formGroup
    (
        set::width('1/2'),
        set::label($lang->deploy->status),
        set::required(true),
        radioList
        (
            set::name('status'),
            set::items($lang->deploy->approvalStatus),
            set::value($setting ? 1 : 0),
            set::inline(true),
            on::change()->call('changeStatus')
        )
    ),
    formGroup
    (
        setID('deployFlow'),
        setClass($setting ? '' : 'hidden'),
        set::width('1/2'),
        set::name('flow'),
        set::label($lang->deploy->flow),
        set::items($flowList),
        set::value($setting),
        set::required(true)
    )
);
