const oldRender = window.renderCell;

window.renderCell = function(result, {col, row})
{
    result = oldRender(result, {col, row});

    if(col.name === 'actions')
    {
        if(col.setting && col.setting.actionsMap && col.setting.actionsMap.logs)
        {
            const logAction = col.setting.actionsMap.logs;
            logAction.url = `javascript:openPipelineLog(${row.id});`;
        }
    }
    if(col.name == 'name' && row.data.engine == 'gitfox')
    {
        const branch = row.data.branch;
        if(!branch)
        {
            result[1] = {};
            return result;
        }
        else
        {
            result[1] = {html:'<span class="label success-pale mr-1">' + branch + '</span>'};
        }
    }

    return result;
};
