ALTER TABLE `zt_build` DROP `artifactRepoID`;
ALTER TABLE `zt_build` ADD `artifacts` TEXT NOT NULL AFTER `bugs`;

CREATE TABLE IF NOT EXISTS `zt_devops_action` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(30) NOT NULL,
  `objectID` mediumint unsigned NOT NULL,
  `actionType` varchar(80) NOT NULL,
  `actionID` varchar(80) NOT NULL,
  `action` varchar(80) NOT NULL,
  `actor` varchar(100) NOT NULL,
  `date` datetime NULL,
  `comment` text NULL,
  `extra` text NULL,
  `product` text NULL,
  `project` mediumint unsigned NOT NULL DEFAULT 0,
  `execution` mediumint unsigned NOT NULL DEFAULT 0,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE INDEX `idx_object_type_id` ON `zt_devops_action`(`objectType`, `objectID`);

CREATE TABLE IF NOT EXISTS `zt_gitfoxsynclog` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `objectType` enum('repo', 'user') NOT NULL DEFAULT 'user',
  `objectID` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `password` varchar(32) NOT NULL DEFAULT '',
  `status` enum('wait', 'synced', 'error') NOT NULL DEFAULT 'wait',
  `operate` enum('add', 'edit', 'del') NOT NULL DEFAULT 'add',
  `times` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `lastSync` datetime NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE INDEX `idx_status_object` ON `zt_gitfoxsynclog`(`status`, `objectType`, `objectID`);

INSERT INTO `zt_cron` (`m`, `h`, `dom`, `mon`, `dow`, `command`, `remark`, `type`, `buildin`, `status`) VALUES ('*/5', '*', '*', '*', '*', 'moduleName=instance&methodName=syncGitFoxData', '同步GitFox数据', 'zentao', 1, 'normal');

ALTER TABLE `zt_repo` ADD `gitfoxID` varchar(255) NOT NULL DEFAULT '' AFTER `synced`;

ALTER TABLE `zt_oauth` ADD `token` varchar(255) NOT NULL DEFAULT '';

CREATE TABLE IF NOT EXISTS `zt_env` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `code` varchar(50) NOT NULL DEFAULT '',
  `system` varchar(255) NOT NULL DEFAULT '',
  `remoteID` MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT 0,
  `type` varchar(32) NOT NULL DEFAULT '',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

ALTER TABLE `zt_host` ADD `CD` varchar(32) NOT NULL DEFAULT 'manual' AFTER `name`;
ALTER TABLE `zt_host` ADD `sshPort` mediumint NOT NULL DEFAULT 0 AFTER `ssh`;
ALTER TABLE `zt_host` ADD `remoteID` MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT 0 AFTER `name`;
ALTER TABLE `zt_host` MODIFY `admin` varchar(30) NOT NULL DEFAULT '0';

ALTER TABLE `zt_deploy` ADD `type` varchar(32) NOT NULL DEFAULT 'manual' AFTER `desc`;
ALTER TABLE `zt_deploy` ADD `env` mediumint(8) unsigned NOT NULL DEFAULT 0;
ALTER TABLE `zt_deploy` ADD `releaseTPL` mediumint(8) unsigned NOT NULL DEFAULT 0;
ALTER TABLE `zt_deploy` ADD `remoteID` mediumint(8) unsigned NOT NULL DEFAULT 0;
ALTER TABLE `zt_deploy` ADD `lastReviewedBy` varchar(30) NOT NULL DEFAULT '';
ALTER TABLE `zt_deploy` ADD `lastReviewedDate` datetime NULL;
ALTER TABLE `zt_deploy` ADD `reviewedBy` varchar(255) NOT NULL DEFAULT '';
ALTER TABLE `zt_deploy` ADD `artifact` TEXT NULL AFTER `releaseTPL`;

CREATE TABLE IF NOT EXISTS `zt_template` (
    `id` int unsigned NOT NULL AUTO_INCREMENT,
    `system` varchar(64)  NOT NULL DEFAULT '',
    `remoteID` mediumint(8) unsigned NOT NULL DEFAULT 0,
    `systemID` mediumint(8) unsigned NOT NULL DEFAULT 0,
    `clusterID` int unsigned NOT NULL DEFAULT 0,
    `settings` text NULL,
    `name` varchar(255) NOT NULL DEFAULT '',
    `hosts` varchar(50)  NOT NULL DEFAULT '',
    `envID` mediumint(8) unsigned NOT NULL DEFAULT 0,
    `desc` varchar(255) NOT NULL DEFAULT '',
    `createdBy` varchar(30)  NOT NULL DEFAULT '',
    `createdDate` datetime DEFAULT NULL,
    `editedBy` varchar(30)  NOT NULL DEFAULT '',
    `editedDate` datetime DEFAULT NULL,
    `deleted` enum('0','1') NOT NULL DEFAULT '0',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB;

ALTER TABLE `zt_system` ADD COLUMN `appKey` varchar(64) NOT NULL DEFAULT '' AFTER `name`;
ALTER TABLE `zt_system` ADD COLUMN `remoteAppID` varchar(32) NOT NULL DEFAULT '' AFTER `name`;

CREATE TABLE IF NOT EXISTS `zt_cluster` (
  `id` INT UNSIGNED AUTO_INCREMENT,
  `name` VARCHAR(255) NOT NULL DEFAULT '',
  `apiUrl` VARCHAR(255) NOT NULL DEFAULT '',
  `token` VARCHAR(255) NOT NULL DEFAULT '',
  `env` INT NOT NULL DEFAULT 0,
  `desc` TEXT NULL,
  `createdBy` VARCHAR(30) NOT NULL DEFAULT '',
  `createdDate` DATETIME NULL,
  `editedBy` VARCHAR(30) NOT NULL DEFAULT '',
  `editedDate` DATETIME NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

ALTER TABLE `zt_metriclib` ADD COLUMN `artifactrepo` char(30) NOT NULL DEFAULT '' AFTER `repo`;
