<?php
/**
 * 检查并安装服务
 * check and install server
 *
 * @param string $appName
 * @param string $customDomain custom domain prefix eg. "monitor"
 * @param string $dbType
 * @param string $dbService
 * @return bool
 */
public function checkAndInstallServer($appName = 'GitFox', $customDomain = '', $dbType = 'sharedDB', $dbService = 'zentaopaas-mysql')
{
    if(!$this->config->inQuickon || $this->config->inQuickon === 'false')
    {
        dao::$errors = $this->lang->upgrade->error->notInQuickon;
        return false;
    }

    $this->loadModel('instance');
    /* Check if app is installed, if it is, start it. */
    $instance = $this->dao->select('*')->from(TABLE_INSTANCE)
        ->where('`chart`')->eq(strtolower($appName))
        ->andWhere('source')->eq('system')
        ->orderBy('id desc')
        ->fetch();
    if($instance)
    {
        if($instance->status != 'running')
        {
            $instance->spaceData = $this->dao->select('*')->from(TABLE_SPACE)->where('id')->eq($instance->space)->fetch();
            $this->instance->start($instance);
        }

        if($appName == 'GitFox')
        {
            $server = $this->instance->getSystemServer();
            if($server)
            {
                $this->dao->update(TABLE_REPO)->set('deleted')->eq(0)->where('SCM')->eq('GitFox')->andWhere('serviceHost')->eq($server->id)->exec();
                $this->dao->update(TABLE_ARTIFACTREPO)->set('deleted')->eq(0)->where('type')->eq('gitfox')->andWhere('serverID')->eq($server->id)->exec();

                $repos = $this->dao->select('*')->from(TABLE_REPO)->where('SCM')->eq('GitFox')->andWhere('serviceHost')->eq($server->id)->fetchAll('id');
                $this->dao->update(TABLE_JOB)->set('deleted')->eq(0)->where('engine')->eq('gitfox')->andWhere('repo')->in(array_keys($repos))->exec();
            }
        }

        $this->instance->updateByID($instance->id, array('deleted' => '0'));
        return true;
    }

    /* Get app. */
    $app = $this->loadModel('store')->getAppInfo(0, false, strtolower($appName), '', $this->config->cloud->api->channel);
    if(!$app)
    {
        dao::$errors = $this->lang->upgrade->error->appNotExist;
        return false;
    }

    $customData = new stdclass();
    $customData->storeAppType = $app->id;
    $customData->type         = 'store';
    $customData->customName   = $appName == 'GitFox' ? $this->lang->instance->systemServer : $appName;
    $customData->customDomain = strtolower($appName);
    $customData->version      = $app->version;
    $customData->dbType       = $dbType;
    $customData->dbService    = $dbService;
    $customData->app_version  = $app->app_version;
    if(!empty($customDomain)) $customData->customDomain = $customDomain;

    $sharedDB = new stdclass();
    $this->loadModel('cne');
    if(isset($app->dependencies->mysql) && $customData->dbType == 'sharedDB')
    {
        $mysqlList = $this->cne->sharedDBList('mysql');
        if($mysqlList) $customData->dbService = key($mysqlList);

        $sharedDB = zget($mysqlList, $customData->dbService, $sharedDB);
    }
    elseif(isset($app->dependencies->postgresql) && $customData->dbType == 'sharedDB')
    {
        $pgList = $this->cne->sharedDBList('postgresql');
        if($pgList) $customData->dbService = key($pgList);

        $sharedDB = zget($pgList, $customData->dbService, $sharedDB);
    }

    $spaceID = null;
    $this->loadModel('space');
    if(in_array($appName, $this->config->space->pluginCharts))
    {
        $account = !empty($this->app->user->account) ? $this->app->user->account : 'system';
        $space   = $this->loadModel('space')->getSystemSpace($account);
        $spaceID = $space->id;
    }
    $resp = $this->instance->install($app, $sharedDB, $customData, $spaceID);
    if(!$resp)
    {
        dao::$errors = $this->lang->space->monitor->cneError;
        return false;
    }
    if($appName == 'GitFox') $this->instance->initSyncData();
    return true;
}

public function stopServer($appName = 'GitFox')
{
    if($appName == 'GitFox')
    {
        $server = $this->loadModel('instance')->getSystemServer();
        if($server)
        {
            $this->dao->update(TABLE_REPO)->set('deleted')->eq(1)->where('SCM')->eq('GitFox')->andWhere('serviceHost')->eq($server->id)->exec();
            $this->dao->update(TABLE_ARTIFACTREPO)->set('deleted')->eq(1)->where('type')->eq('gitfox')->andWhere('serverID')->eq($server->id)->exec();

            $repos = $this->dao->select('*')->from(TABLE_REPO)->where('SCM')->eq('GitFox')->andWhere('serviceHost')->eq($server->id)->fetchAll('id');
            $this->dao->update(TABLE_JOB)->set('deleted')->eq(1)->where('engine')->eq('gitfox')->andWhere('repo')->in(array_keys($repos))->exec();
        }
    }

    $instance = $this->loadModel('instance')->getSystemInstance($appName);
    if($instance && $instance->source == 'system')
    {
        if($instance->status == 'running')
        {
            $instance->spaceData = $this->dao->select('*')->from(TABLE_SPACE)->where('id')->eq($instance->space)->fetch();
            $this->instance->stop($instance);
        }
        $this->instance->updateByID($instance->id, array('deleted' => '1'));
    }
}
