let instanceListFunc = null;
if(window.renderInstanceList) instanceListFunc = window.renderInstanceList;
window.renderInstanceList = function(result, {col, row, value})
{
    result = instanceListFunc(result, {col, row, value});
    if(col.name === 'name')
    {
        let id      = "instanceID-" + row.id;
        let monitor = ' <span id="' + id + '"></span>';
        if(row.data.monitor && row.data.monitor.warning && row.data.monitor.warning.tips)
        {
            monitor = ' <span id="' + id + '" title="' + row.data.monitor.warning.tips + '"><i class="icon icon-exclamation rounded-full warning-pale"></i></span>';
        }
        /* danger monitor priority display */
        if(row.data.monitor && row.data.monitor.danger && row.data.monitor.danger.tips)
        {
            monitor = ' <span id="' + id + '" title="' + row.data.monitor.danger.tips + '"><i class="icon icon-exclamation rounded-full danger-pale"></i></span>';
        }
        result[0] = {html: '<a href="' + $.createLink('instance', 'view', 'id=' + row.id) + '">' + row.data.name + '</a>' + monitor};
    }
    return result;
}

$(function()
{
    if(typeof monitorTimer !== 'undefined') clearInterval(monitorTimer);
    if(instanceIdList.length === 0) return;
    if(inQuickon) monitorTimer = setInterval(refreshAlerts, 60000);
});

function refreshAlerts()
{
    $.each(instanceIdList, function(index, id)
    {
        $("#instanceID-" + id).html('');
    });
    $.ajaxSubmit({
        url: $.createLink('space', 'ajaxAlerts'),
        onComplete: function(res)
        {
            if(res.result === 'success')
            {
                $.each(res.data, function(index, alert)
                {
                    let id   = "instanceID-" + index;
                    if(alert.warning && alert.warning.tips)
                    {
                        $("#" + id).attr('title', alert.warning.tips).html('<i class="icon icon-exclamation rounded-full warning-pale"></i>');
                    }
                    if(alert.danger && alert.danger.tips)
                    {
                        $("#" + id).attr('title', alert.danger.tips).html('<i class="icon icon-exclamation rounded-full danger-pale"></i>');
                    }
                });
            }
        }
    });
}
