function initLineChart(chartData, type)
{
    const data = {baseData: [], otherData: []};
    const date = [];
    for(let day in chartData)
    {
        const dateArr = day.split('-');
        date.push(dateArr[1] + '/' + dateArr[2]);
        data.baseData.push(chartData[day].base);
        data.otherData.push(chartData[day].other);
    }

    const chartDom = document.getElementById(type);
    const myChart  = echarts.init(chartDom);
    const option = {
        title: {
            text: devopsLang[type],
            top: 'top',
            left: 'center',
            textStyle: {
                color: '#a1c4e9',
                fontSize: 15
            }
        },
        tooltip: {
            trigger: 'axis',
            valueFormatter: (value) => (value == undefined ? 0 : value)
        },
        legend: {
            data: devopsLang.legend[type],
            type: 'scroll',
            textStyle:{
                color: '#dee0e4',
                fontSize: 14,
            },
            top: 'bottom',
            left: 'center',
        },
        color: ['#2567CF', '#51EAFF'],
        grid: {
            left: '0%',
            right: '0%',
            top: 65,
            bottom: '10%',
            containLabel: true
        },
        xAxis: {
            type: 'category',
            name: '',
            axisLabel: {
                rotate: 45,
                show: true,
                textStyle: {
                    color: '#dee0e4'
                }
            },
            data: date
        },
        yAxis: {
            type: 'value',
            name: '',
            nameTextStyle:{
                padding: [0, 0, -40, -45]
            },
            axisLabel: {
                show: true,
                textStyle: {
                    color: '#dee0e4'
                }
            },
            axisLine: {
                show: true
            },
            splitLine: {
                show: true,
                lineStyle:{
                    color: ['#182a43'],
                    width: 2,
                    type: 'solid'
                }
            },
        },
        series: [
            {
                name: devopsLang.legend[type][0],
                symbol: 'circle',
                symbolSize: 4,
                type: 'line',
                lineStyle: {
                    "width": 2,
                    "type": "solid"
                },
                data: data.baseData
            },
            {
              name: devopsLang.legend[type][1],
              symbol: 'circle',
              symbolSize: 4,
              type: 'line',
              lineStyle: {
                "width": 2,
                "type": "solid"
              },
              data: data.otherData
            }
        ]
    };

    myChart.setOption(option);
}

function initBarChart(chartData, type, rule)
{
    const data = [];
    const date = [];
    chartData.forEach((item) => {
        const dateArr = item.key.split('-');
        let dateStr = dateArr.length > 2 ? dateArr[1] + '/' + dateArr[2] : dateArr[0];
        if(item.key.includes('-') && dateArr.length == 2) dateStr = dateArr[0] + '/' + dateArr[1];

        date.push(dateStr);
        data.push(item.count);
    });

    const chartDom = document.getElementById(type);
    const myChart  = echarts.init(chartDom);
    const option = {
        title: {
            text: devopsLang[type],
            top: 'top',
            left: 'center',
            textStyle: {
                color: '#a1c4e9',
                fontSize: 15
            }
        },
        tooltip: {
            trigger: 'axis',
            valueFormatter: (value) => (value == undefined ? 0 : value)
        },
        legend: {
            data: devopsLang.legend[type],
            type: 'scroll',
            textStyle:{
                color: '#dee0e4',
                fontSize: 14,
            },
            top: 'bottom',
            left: 'center',
        },
        color: ['#2567CF'],
        grid: {
            left: '1%',
            right: '1%',
            top: 65,
            bottom: '10%',
            containLabel: true
        },
        xAxis: {
            type: rule == 'row' ? 'value' : 'category',
            name: '',
            nameTextStyle:{
                padding: [20, 20, 0, -40],
            },
            axisLabel: {
                rotate: rule == 'row' ? 0 : 45,
                show: true,
                textStyle: {
                    color: '#dee0e4'
                }
            },
            data: rule == 'row' ? [] : date
        },
        yAxis: {
            type: rule == 'row' ? 'category' : 'value',
            name: '',
            nameTextStyle:{
                padding: [0, 0, -40, -45]
            },
            axisLabel: {
                show: true,
                interval: 0,
                textStyle: {
                    color: '#dee0e4'
                }
            },
            axisLine: {
                show: true
            },
            splitLine: {
                show: true,
                lineStyle:{
                    color: ['#182a43'],
                    width: 2,
                    type: 'solid'
                }
            },
            data: rule == 'row' ? date.reverse() : []
        },
        series: [
            {
                name: devopsLang.legend[type][0],
                symbol: 'circle',
                symbolSize: 4,
                type: 'bar',
                data: rule == 'row' ? data.reverse() : data
            }
        ]
    };

    myChart.setOption(option);
}

$(function()
{
    $("#begin").datetimepicker('setStartDate', minDate);
    $("#begin").datetimepicker('setEndDate', endDate);

    $("#end").datetimepicker('setStartDate', beginDate);
    $("#end").datetimepicker('setEndDate', maxDate);

    initLineChart(issueChart,    'repoTrend');
    initLineChart(pipelineChart, 'pipelineTrend');

    initBarChart(commitStat, 'repoCommit');
    initBarChart(userStat,   'repoRank', 'row');

    $('#repo').on('change', function()
    {
        $.getJSON(createLink('report', 'ajaxGetDevopsChart', `begin=${begin}&end=${end}&repo=${$(this).val()}`), function(data)
        {
            if(!data) return;

            initLineChart(data.issueChart,    'repoTrend');
            initLineChart(data.pipelineChart, 'pipelineTrend');

            initBarChart(data.commitStat, 'repoCommit');
            initBarChart(data.userStat,   'repoRank', 'row');
        });
    });

    $('#begin, #end').on('change', function()
    {
        const beginTime = new Date($('#begin').val()).getTime();
        const endTime   = new Date($('#end').val()).getTime();
        location.href = createLink('screen', 'view', `screenID=${screenID}&begin=${beginTime / 1000}&end=${endTime / 1000}&repo=${$('#repo').val()}`);
    });

    $('[data-toggle="popover"]').popover();
})
