<?php
/**
 * The view webhook request view file of repo module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yang Li <liyang@chandao.com>
 * @package     repo
 * @link        https://www.zentao.net
 */
namespace zin;

modalHeader
(
    set::title($lang->repo->viewWebhookRequest),
    set::titleClass('panel-title text-lg')
);
$requestBody = json_decode($execLog->request->body);
$requestBody = json_encode($requestBody, JSON_PRETTY_PRINT);
h::css('.codeBody {background: #eee; border: 1px solid #aaa; padding: 0.4em 0.8em; font-size: 12px; overflow: auto; color: #000; margin: 12px 0;}');

div
(
    div
    (
        h5($lang->repo->webhook->requestURL),
        h::pre
        (
            setClass('codeBody'),
            h::code($execLog->request->url)
        )
    ),
    div
    (
        h5($lang->repo->webhook->triggerType),
        h::pre
        (
            setClass('codeBody'),
            h::code(zget($lang->repo->webhook->customEventList, $execLog->trigger_type))
        )
    ),
    div
    (
        h5($lang->repo->webhook->requestHeaders),
        h::pre
        (
            setClass('codeBody'),
            h::code($execLog->request->headers)
        )
    ),
    div
    (
        h5($lang->repo->webhook->requestBody),
        h::pre
        (
            setClass('codeBody'),
            h::code($requestBody)
        )
    ),
    div
    (
        h5($lang->repo->webhook->responseHeaders),
        h::pre
        (
            setClass('codeBody'),
            h::code($execLog->response->headers ? $execLog->response->headers : $lang->repo->webhook->emptyData)
        )
    ),
    div
    (
        h5($lang->repo->webhook->responseBody),
        h::pre
        (
            setClass('codeBody'),
            h::code($execLog->response->body ? $execLog->response->body : $lang->repo->webhook->emptyData)
        )
    )
);
